/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.plugins.fileopensave.api.providers;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.plugins.fileopensave.api.file.FileDetails;
import org.pentaho.di.plugins.fileopensave.api.providers.File;
import org.pentaho.di.plugins.fileopensave.api.providers.FileProvider;
import org.pentaho.di.plugins.fileopensave.api.providers.Utils;
import org.pentaho.di.plugins.fileopensave.api.providers.exception.FileException;
import org.pentaho.di.ui.core.FileDialogOperation;

public abstract class BaseFileProvider<T extends File>
implements FileProvider<T> {
    @Override
    public String sanitizeName(T destDir, String newPath) {
        return newPath;
    }

    @Override
    public void setFileProperties(FileDetails fileDetails, FileDialogOperation fileDialogOperation) {
        fileDialogOperation.setPath(fileDetails.getPath());
        fileDialogOperation.setFilename(fileDetails.getName());
        fileDialogOperation.setConnection(fileDetails.getConnection());
        fileDialogOperation.setProvider(fileDetails.getProvider());
    }

    @Override
    public List<T> searchFiles(T file, String filters, String searchString, VariableSpace space) throws FileException {
        List<T> files = this.getFiles(file, filters, space);
        return files.stream().filter(resultFile -> StringUtils.isEmpty((String)searchString) || Utils.matches(file.getName(), searchString)).collect(Collectors.toList());
    }
}

