/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import com.infobright.io.NamedPipe;
import com.infobright.util.ProcessUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class LinuxNamedPipe
extends NamedPipe {
    private static final String PIPE_MODE = "644";
    private static final String CHMOD_CMD = "chmod";
    private static final String MKFIFO_CMD = "mkfifo";
    private FileInputStream inputStream;
    private OutputStream outputStream;

    static final String getNativeName(String name) {
        return String.format("/tmp/%s", name);
    }

    LinuxNamedPipe(String name, boolean createFIFO) throws IOException {
        super(LinuxNamedPipe.getNativeName(name));
        String pipeName = this.getPipeName();
        if (createFIFO) {
            if (!new File(pipeName).exists()) {
                ProcessUtil.runCommand(new String[]{MKFIFO_CMD, pipeName});
                ProcessUtil.runCommand(new String[]{CHMOD_CMD, PIPE_MODE, pipeName});
            } else {
                throw new RuntimeException("Can't create named pipe \"" + pipeName + "\" as it already exists.");
            }
        }
    }

    public void connect() throws IOException {
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new FileInputStream(this.getPipeName());
        }
        return this.inputStream.read(bytes, offset, length);
    }

    public int write(byte[] bytes, int offset, int length) throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new FileOutputStream(this.getPipeName());
        }
        this.outputStream.write(bytes, offset, length);
        return length;
    }

    public void close() throws IOException {
        File file;
        if (this.outputStream == null) {
            this.outputStream = new FileOutputStream(this.getPipeName());
        }
        this.outputStream.close();
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if ((file = new File(this.getPipeName())).exists()) {
            file.delete();
        }
        this.outputStream = null;
        this.inputStream = null;
    }
}

