/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class SmallintType
extends AbstractColumnType {
    private Short data = new Short(0);

    SmallintType() {
    }

    public String getDataAsString() {
        return this.data.toString();
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.putShort(this.data);
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        this.data = byteBuffer.getShort();
    }

    public void setData(String string) {
        this.data = Short.valueOf(string);
    }

    protected void zeroOutData() {
        this.data = 0;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Long val = meta.getInteger(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (val >= 32768L || val < -32768L) {
                    throw new ValueConverterException("Value " + val + " out of range for SMALLINT");
                }
                this.data = val.shortValue();
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

