/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.agent;

import com.infobright.etl.agent.UsageException;
import com.infobright.logging.ConsoleEtlLogger;

class CLArgs {
    public static final ConsoleEtlLogger.Level DEFAULT_LOGLEVEL = ConsoleEtlLogger.Level.INFO;
    private static final String PORT_FLAG = "-p";
    private static final String LOGLEVEL_FLAG = "-l";
    private final int port;
    private final ConsoleEtlLogger.Level logLevel;

    CLArgs(String[] args) throws UsageException {
        try {
            this.port = this.parsePort(args);
            this.logLevel = this.parseLogLevel(args);
        }
        catch (Exception e) {
            throw new UsageException();
        }
    }

    private int parsePort(String[] args) throws UsageException {
        int port2 = 5555;
        for (int i = 0; i < args.length; ++i) {
            if (!PORT_FLAG.equals(args[i])) continue;
            if (i < args.length - 1) {
                port2 = Integer.parseInt(args[i + 1]);
                break;
            }
            throw new UsageException();
        }
        return port2;
    }

    private ConsoleEtlLogger.Level parseLogLevel(String[] args) throws UsageException {
        ConsoleEtlLogger.Level level = DEFAULT_LOGLEVEL;
        for (int i = 0; i < args.length; ++i) {
            if (!LOGLEVEL_FLAG.equals(args[i])) continue;
            if (i < args.length - 1) {
                level = ConsoleEtlLogger.Level.valueOf(args[i + 1].toUpperCase());
                break;
            }
            throw new UsageException();
        }
        return level;
    }

    int getPort() {
        return this.port;
    }

    ConsoleEtlLogger.Level getLogLevel() {
        return this.logLevel;
    }
}

