/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1SetInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.OIDRegistrar;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.util.InvalidFormatException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;

public class X500RDN
implements ASN1Object,
Externalizable {
    private LinkedHashMap<ASN1ObjectID, AttributeTypeAndValue> attrSet = new LinkedHashMap();
    private ASN1Set contents = null;

    public X500RDN() {
    }

    public X500RDN(ASN1ObjectID type, ASN1Object value) {
        this.attrSet.put(type, new AttributeTypeAndValue(type, value));
    }

    public X500RDN(ASN1ObjectID type, String value) {
        this.addAttribute(type, value);
    }

    public X500RDN(InputStream is) throws IOException {
        this.input(is);
    }

    X500RDN(String s) {
        this.input(s);
    }

    public void addAttribute(ASN1ObjectID type, ASN1Object value) {
        this.contents = null;
        this.attrSet.put(type, new AttributeTypeAndValue(type, value));
    }

    public void addAttribute(ASN1ObjectID type, String value) {
        int stringType = type.equals((Object)PKIX.emailAddress) || type.equals((Object)PKIX.id_domainComponent) ? 22 : 19;
        char[] c = value.toCharArray();
        int len = c.length;
        for (int i = 0; i < len; ++i) {
            if (c[i] <= '\u007f' && (stringType != 19 || X500RDN.isASN1Printable(c[i]))) continue;
            stringType = 12;
            break;
        }
        this.addAttribute(type, (ASN1Object)new ASN1String(value, stringType));
    }

    private void addAttribute(AttributeTypeAndValue tv) {
        this.contents = null;
        this.attrSet.put(tv.getType(), tv);
    }

    public Enumeration<ASN1ObjectID> types() {
        return this.attrSet == null ? null : new Vector<ASN1ObjectID>(this.attrSet.keySet()).elements();
    }

    public Map<ASN1ObjectID, AttributeTypeAndValue> getValues() {
        return this.attrSet;
    }

    public ASN1Object getValue(ASN1ObjectID type) {
        AttributeTypeAndValue tv = this.attrSet.get(type);
        return tv != null ? tv.getValue() : null;
    }

    public int hashCode() {
        return Utils.hashBytes((Streamable)this.toASN1Set());
    }

    private static String fixWhitespace(String s) {
        String t = s.trim();
        if (t.length() == 0) {
            return t;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(t.charAt(0));
        int len = t.length();
        for (int i = 1; i < len; ++i) {
            char c = t.charAt(i);
            if (Character.isWhitespace(c)) {
                if (Character.isWhitespace(t.charAt(i - 1))) continue;
                buf.append(' ');
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X500RDN x = (X500RDN)o;
        if (this.attrSet.size() != x.attrSet.size()) {
            return false;
        }
        Iterator<AttributeTypeAndValue> e = this.attrSet.values().iterator();
        Iterator<AttributeTypeAndValue> f = x.attrSet.values().iterator();
        while (e.hasNext() && f.hasNext()) {
            AttributeTypeAndValue a = e.next();
            AttributeTypeAndValue b = f.next();
            if (!a.getType().equals((Object)b.getType())) {
                return false;
            }
            if (a.getValue().getClass() != b.getValue().getClass()) {
                return false;
            }
            if (a.getValue() instanceof ASN1String) {
                ASN1String s = (ASN1String)a.getValue();
                ASN1String t = (ASN1String)b.getValue();
                if (!(s.getTag() == 19 && t.getTag() == 19 ? !X500RDN.fixWhitespace(s.getValue()).equalsIgnoreCase(X500RDN.fixWhitespace(t.getValue())) : !s.getValue().equals(t.getValue()))) continue;
                return false;
            }
            if (Utils.areEqual((byte[])Utils.toBytes((Streamable)a.getValue()), (byte[])Utils.toBytes((Streamable)b.getValue()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean escapeUnicode) {
        StringBuffer s = new StringBuffer();
        for (AttributeTypeAndValue tv : this.attrSet.values()) {
            String name = X500RDN.getTypeName(tv.getType());
            s.append(name != null ? name : tv.getType().toStringCompact());
            s.append('=');
            ASN1Object value = tv.getValue();
            if (value instanceof ASN1String) {
                s.append(X500RDN.escapeValue(((ASN1String)value).getValue(), escapeUnicode));
            } else {
                s.append('#');
                s.append(Utils.toHexString((byte[])Utils.toBytes((Streamable)value)));
            }
            s.append('+');
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    public String toASCII() {
        return this.toString(true);
    }

    static String escapeValue(String s, boolean escapeUnicode) {
        StringBuffer t = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (escapeUnicode && c >= '\u0080') {
                StringBuffer u = new StringBuffer();
                while (true) {
                    u.append(c);
                    if (i == s.length() || s.charAt(i + 1) < '\u0080') break;
                    c = s.charAt(++i);
                }
                String hex = Utils.toHexString((byte[])Utils.toUTF8((String)u.toString()));
                int size = hex.length();
                for (int j = 0; j < size; j += 2) {
                    t.append('\\');
                    t.append(hex.charAt(j));
                    t.append(hex.charAt(j + 1));
                }
                continue;
            }
            if (c < ' ' || c == '\u007f' || i == 0 && c == ' ' || i == s.length() - 1 && c == ' ') {
                String hex = Integer.toString(c, 16);
                t.append('\\');
                if (c < '\u0010') {
                    t.append('0');
                }
                t.append(hex);
                continue;
            }
            if (X500RDN.isSpecial(c) || c == '\\' || c == '\"') {
                t.append('\\');
            }
            t.append(c);
        }
        return t.toString();
    }

    static String unescapeValue(String s) {
        StringBuffer t = new StringBuffer(s.length());
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) == '\\' && i < s.length() - 1) {
                t.append(s.charAt(++i));
                continue;
            }
            t.append(s.charAt(i));
        }
        return t.toString();
    }

    static ASN1ObjectID getTypeID(String name) {
        return OIDManager.getOIDManager().getAttributeType(name);
    }

    private static String getTypeName(ASN1ObjectID oid) {
        return OIDManager.getOIDManager().getAttributeName(oid);
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexChar(char c) {
        return X500RDN.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isSpecial(char c) {
        return c == ',' || c == '+' || c == '=' || c == '<' || c == '>' || c == ';' || c == '#';
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    static boolean isASN1Printable(char c) {
        return X500RDN.isAlpha(c) || X500RDN.isDigit(c) || c == ' ' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == '=' || c == '?';
    }

    public void input(InputStream is) throws IOException {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        ASN1SetInputStream setIS = new ASN1SetInputStream(is);
        while (setIS.hasMoreData()) {
            AttributeTypeAndValue tv = new AttributeTypeAndValue((InputStream)setIS);
            if (tv == null) continue;
            this.attrSet.put(tv.getType(), tv);
        }
        setIS.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Set().output(os);
    }

    public int length() {
        return this.toASN1Set().length();
    }

    private ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set s = new ASN1Set();
            Iterator<AttributeTypeAndValue> e = this.attrSet.values().iterator();
            while (e.hasNext()) {
                s.addElement((ASN1Object)e.next());
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void input(String s) {
        this.contents = null;
        this.attrSet = new LinkedHashMap();
        StringBuffer a = new StringBuffer();
        boolean quoting = false;
        boolean foundAttr = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '+' && !quoting && i > 0 && s.charAt(i - 1) != '\\') {
                foundAttr = true;
            } else if (c == '\"') {
                quoting = !quoting;
                a.append(c);
            } else {
                a.append(c);
            }
            if (!foundAttr && ++i != s.length()) continue;
            this.parseAttribute(a.toString());
            a = new StringBuffer();
            quoting = false;
            foundAttr = false;
        }
    }

    private void parseAttribute(String s) {
        String vs;
        int j0;
        int i = 0;
        i = s.indexOf("=");
        if (i == -1) {
            throw new InvalidFormatException("'=' missing in attribute");
        }
        for (j0 = 0; j0 < i && X500RDN.isWhitespace(s.charAt(j0)); ++j0) {
        }
        if (j0 == i) {
            throw new InvalidFormatException("Attribute type missing");
        }
        int j1 = i - 1;
        while (j1 >= 0 & X500RDN.isWhitespace(s.charAt(j1))) {
            --j1;
        }
        String ts = s.substring(j0, j1 + 1);
        ASN1ObjectID type = X500RDN.isDigit(ts.charAt(0)) ? new ASN1ObjectID(ts) : (ts.toUpperCase().startsWith("OID.") ? new ASN1ObjectID(ts.substring(4)) : X500RDN.getTypeID(ts));
        if (type == null) {
            throw new InvalidFormatException("Malformed attribute type");
        }
        ++i;
        while (i < s.length() && X500RDN.isWhitespace(s.charAt(i))) {
            ++i;
        }
        int j = s.length() - 1;
        while (X500RDN.isWhitespace(s.charAt(j))) {
            --j;
        }
        String string = vs = j >= i ? s.substring(i, j + 1) : "";
        if (vs.startsWith("#") && vs.length() > 1) {
            try {
                this.addAttribute(type, ASN1Utils.inputASN1Object((byte[])Utils.fromHexString((String)vs.substring(1))));
                return;
            }
            catch (IOException ex) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
            catch (NumberFormatException ex) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
        }
        boolean quoted = false;
        if (vs.startsWith("\"")) {
            if (vs.length() == 1 || !vs.endsWith("\"")) {
                throw new InvalidFormatException("Missing final '\"'");
            }
            vs = vs.substring(1, vs.length() - 1);
            quoted = true;
        }
        StringBuffer v = new StringBuffer(vs.length());
        int len = vs.length();
        for (i = 0; i < len; ++i) {
            char c = vs.charAt(i);
            if (c == '\\') {
                try {
                    if (X500RDN.isHexChar(vs.charAt(i + 1))) {
                        UnsyncByteArrayOutputStream b = new UnsyncByteArrayOutputStream();
                        while (true) {
                            b.write(Integer.parseInt(vs.substring(i + 1, i + 3), 16));
                            if ((i += 2) >= vs.length() - 1 || vs.charAt(i + 1) != '\\' || !X500RDN.isHexChar(vs.charAt(i + 2))) break;
                            ++i;
                        }
                        v.append(Utils.fromUTF8((byte[])b.toByteArray()));
                        continue;
                    }
                    if (X500RDN.isSpecial(c = vs.charAt(++i)) || c == '\\' || c == '\"') {
                        v.append(c);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex.toString());
                }
            }
            if (!quoted && (X500RDN.isSpecial(c) || c == '\\' || c == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            if (quoted && (c == '\\' || c == '\"')) {
                throw new IllegalArgumentException("Malformed attribute value string");
            }
            v.append(c);
        }
        this.addAttribute(type, v.toString());
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }

    static {
        OIDRegistrar.mapAttributeTypeNames();
    }
}

