/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.io.Serializable;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonTransformationDelegate;
import org.pentaho.xul.swt.tab.TabItem;

public class SpoonEETransformationDelegate
extends SpoonTransformationDelegate
implements Serializable {
    private static final long serialVersionUID = -2067024540694335010L;
    ILockService service;

    public SpoonEETransformationDelegate(Spoon spoon) {
        super(spoon);
        Repository repository = spoon.getRepository();
        try {
            if (!repository.hasService(ILockService.class)) {
                throw new IllegalStateException();
            }
            this.service = (ILockService)repository.getService(ILockService.class);
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    public void addTransGraph(TransMeta transMeta) {
        super.addTransGraph(transMeta);
        TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry((Object)transMeta);
        if (tabEntry != null) {
            TabItem tabItem = tabEntry.getTabItem();
            try {
                if (this.service != null && transMeta.getObjectId() != null && this.service.getTransformationLock(transMeta.getObjectId()) != null) {
                    tabItem.setImage(GUIResource.getInstance().getImageLocked());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

