/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.pur.model.IEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIEEUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.UIEEObjectRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.model.IUIUser;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UISecurityUser;
import org.pentaho.ui.xul.util.AbstractModelList;

public class UIEESecurityUser
extends UISecurityUser
implements Serializable {
    private static final long serialVersionUID = 3632015987344690267L;
    private AbstractModelList<IUIRole> availableRoles;
    private AbstractModelList<IUIRole> assignedRoles;
    private List<IUIRole> availableSelectedRoles = new ArrayList<IUIRole>();
    private List<IUIRole> assignedSelectedRoles = new ArrayList<IUIRole>();
    private boolean roleAssignmentPossible;
    private boolean roleUnassignmentPossible;

    public UIEESecurityUser(RepositorySecurityManager rsm) {
        super(rsm);
        this.availableRoles = new AbstractModelList();
        this.availableRoles.addPropertyChangeListener("children", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UIEESecurityUser.this.firePropertyChange("availableRoles", null, UIEESecurityUser.this.availableRoles);
            }
        });
        this.assignedRoles = new AbstractModelList();
        this.assignedRoles.addPropertyChangeListener("children", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                UIEESecurityUser.this.firePropertyChange("assignedRoles", null, UIEESecurityUser.this.assignedRoles);
            }
        });
    }

    public void setUser(IUIUser user, List<IUIRole> roles) throws Exception {
        super.setUser(user);
        this.setAvailableRoles(roles);
        if (user instanceof IUIEEUser) {
            for (IUIRole role : ((IUIEEUser)user).getRoles()) {
                this.removeFromAvailableRoles(role.getName());
                this.addToAssignedRoles(UIEEObjectRegistery.getInstance().constructUIRepositoryRole(role.getRole()));
            }
        }
    }

    public List<IUIRole> getAvailableSelectedRoles() {
        return this.availableSelectedRoles;
    }

    public void setAvailableSelectedRoles(List<Object> availableSelectedRoles) {
        ArrayList<IUIRole> previousVal = new ArrayList<IUIRole>();
        previousVal.addAll(this.availableSelectedRoles);
        this.availableSelectedRoles.clear();
        if (availableSelectedRoles != null && availableSelectedRoles.size() > 0) {
            for (Object role : availableSelectedRoles) {
                this.availableSelectedRoles.add((IUIRole)role);
            }
        }
        this.firePropertyChange("availableSelectedRoles", previousVal, this.availableSelectedRoles);
        this.fireRoleAssignmentPropertyChange();
    }

    public List<IUIRole> getAssignedSelectedRoles() {
        return this.assignedSelectedRoles;
    }

    public void setAssignedSelectedRoles(List<Object> assignedSelectedRoles) {
        ArrayList<IUIRole> previousVal = new ArrayList<IUIRole>();
        previousVal.addAll(this.assignedSelectedRoles);
        this.assignedSelectedRoles.clear();
        if (assignedSelectedRoles != null && assignedSelectedRoles.size() > 0) {
            for (Object role : assignedSelectedRoles) {
                this.assignedSelectedRoles.add((IUIRole)role);
            }
        }
        this.firePropertyChange("assignedSelectedRoles", previousVal, this.assignedSelectedRoles);
        this.fireRoleUnassignmentPropertyChange();
    }

    public UIEESecurityUser getUISecurityUser() {
        return this;
    }

    public List<IUIRole> getAvailableRoles() {
        return this.availableRoles;
    }

    public void setAvailableRoles(List<IUIRole> availableRoles) {
        List<IUIRole> previousValue = this.getPreviousAvailableRoles();
        this.availableRoles.clear();
        if (availableRoles != null) {
            this.availableRoles.addAll(availableRoles);
        }
        this.firePropertyChange("availableRoles", previousValue, this.availableRoles);
    }

    public List<IUIRole> getAssignedRoles() {
        return this.assignedRoles;
    }

    public void updateAssignedRoles(List<IUIRole> assignedRoles) {
        for (IUIRole role : assignedRoles) {
            this.assignRole(role);
        }
    }

    public void setAssignedRoles(List<IUIRole> selectedRoles) {
        List<IUIRole> previousValue = this.getPreviousAssignedRoles();
        this.assignedRoles.clear();
        if (selectedRoles != null) {
            this.assignedRoles.addAll(selectedRoles);
        }
        this.firePropertyChange("assignedRoles", previousValue, this.assignedRoles);
    }

    public void clear() {
        super.clear();
        this.setAssignedSelectedRoles(null);
        this.setAvailableSelectedRoles(null);
        this.setAvailableRoles(null);
        this.setAssignedRoles(null);
        this.setRoleAssignmentPossible(false);
        this.setRoleUnassignmentPossible(false);
    }

    public void assignRoles(List<Object> rolesToAssign) {
        for (Object roleToAssign : rolesToAssign) {
            this.assignRole((IUIRole)roleToAssign);
        }
        this.setAssignedSelectedRoles(rolesToAssign);
        this.setAvailableSelectedRoles(new ArrayList<Object>());
        this.firePropertyChange("roleAssignmentPossible", null, false);
    }

    public void assignRole(IUIRole roleToAssign) {
        this.addToAssignedRoles(roleToAssign);
        this.removeFromAvailableRoles(roleToAssign.getName());
    }

    public void unassignRoles(List<Object> rolesToUnAssign) {
        for (Object roleToUnAssign : rolesToUnAssign) {
            this.unassignRole((IUIRole)roleToUnAssign);
        }
        this.setAvailableSelectedRoles(rolesToUnAssign);
        this.setAssignedSelectedRoles(new ArrayList<Object>());
        this.firePropertyChange("roleUnassignmentPossible", null, false);
    }

    public void unassignRole(IUIRole roleToUnAssign) {
        this.removeFromAssignedRoles(roleToUnAssign.getName());
        this.addToAvailableRoles(roleToUnAssign);
    }

    public boolean isRoleAssignmentPossible() {
        return this.roleAssignmentPossible;
    }

    public void setRoleAssignmentPossible(boolean roleAssignmentPossible) {
        this.roleAssignmentPossible = roleAssignmentPossible;
        this.fireRoleAssignmentPropertyChange();
    }

    public boolean isRoleUnassignmentPossible() {
        return this.roleUnassignmentPossible;
    }

    public void setRoleUnassignmentPossible(boolean roleUnassignmentPossible) {
        this.roleUnassignmentPossible = roleUnassignmentPossible;
        this.fireRoleUnassignmentPropertyChange();
    }

    public IUser getUserInfo() throws KettleException {
        IUser userInfo = this.rsm.constructUser();
        userInfo.setDescription(this.getDescription());
        userInfo.setLogin(this.getName());
        userInfo.setName(this.getName());
        userInfo.setUsername(this.getName());
        userInfo.setPassword(this.getPassword());
        if (userInfo instanceof IEEUser) {
            for (IUIRole role : this.getAssignedRoles()) {
                ((IEEUser)userInfo).addRole(role.getRole());
            }
        }
        return userInfo;
    }

    private void addToAssignedRoles(IUIRole roleToAdd) {
        List<IUIRole> previousValue = this.getPreviousAssignedRoles();
        this.assignedRoles.add((Object)roleToAdd);
        this.firePropertyChange("assignedRoles", previousValue, this.assignedRoles);
        if (this.assignedRoles.size() == 1) {
            this.setRoleUnassignmentPossible(true);
        }
        this.fireRoleUnassignmentPropertyChange();
    }

    private void addToAvailableRoles(IUIRole roleToAdd) {
        List<IUIRole> previousValue = this.getPreviousAvailableRoles();
        this.availableRoles.add((Object)roleToAdd);
        if (this.availableRoles.size() == 1) {
            this.setRoleAssignmentPossible(true);
        }
        this.firePropertyChange("availableRoles", previousValue, this.availableRoles);
        this.fireRoleAssignmentPropertyChange();
    }

    private void removeFromAvailableRoles(String roleName) {
        List<IUIRole> previousValue = this.getPreviousAvailableRoles();
        this.availableRoles.remove((Object)this.getAvailableRole(roleName));
        if (this.availableRoles.size() == 0) {
            this.setRoleAssignmentPossible(false);
        }
        this.firePropertyChange("availableRoles", previousValue, this.availableRoles);
        this.fireRoleAssignmentPropertyChange();
    }

    private void removeFromAssignedRoles(String roleName) {
        List<IUIRole> previousValue = this.getPreviousAssignedRoles();
        this.assignedRoles.remove((Object)this.getSelectedRole(roleName));
        if (this.assignedRoles.size() == 0) {
            this.setRoleUnassignmentPossible(false);
        }
        this.firePropertyChange("assignedRoles", previousValue, this.assignedRoles);
        this.fireRoleUnassignmentPropertyChange();
    }

    private void fireRoleUnassignmentPropertyChange() {
        if (this.roleUnassignmentPossible && this.assignedRoles.size() > 0 && this.assignedSelectedRoles.size() > 0) {
            this.firePropertyChange("roleUnassignmentPossible", null, true);
        } else {
            this.firePropertyChange("roleUnassignmentPossible", null, false);
        }
    }

    private void fireRoleAssignmentPropertyChange() {
        if (this.roleAssignmentPossible && this.availableRoles.size() > 0 && this.availableSelectedRoles.size() > 0) {
            this.firePropertyChange("roleAssignmentPossible", null, true);
        } else {
            this.firePropertyChange("roleAssignmentPossible", null, false);
        }
    }

    private IUIRole getSelectedRole(String name) {
        for (IUIRole role : this.assignedRoles) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    private IUIRole getAvailableRole(String name) {
        for (IUIRole role : this.availableRoles) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    private List<IUIRole> getPreviousAvailableRoles() {
        ArrayList<IUIRole> previousValue = new ArrayList<IUIRole>();
        for (IUIRole ru : this.availableRoles) {
            previousValue.add(ru);
        }
        return previousValue;
    }

    private List<IUIRole> getPreviousAssignedRoles() {
        ArrayList<IUIRole> previousValue = new ArrayList<IUIRole>();
        for (IUIRole ru : this.assignedRoles) {
            previousValue.add(ru);
        }
        return previousValue;
    }
}

