/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.model;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.IUIRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.IUIAbsRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEESecurity;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityManager;

public class UIAbsSecurity
extends UIEESecurity
implements Serializable {
    private static final long serialVersionUID = -8131064658827613758L;

    public UIAbsSecurity() {
    }

    public UIAbsSecurity(RepositorySecurityManager rsm) throws Exception {
        super(rsm);
        for (IUIRole systemRole : this.systemRoleList) {
            if (rsm instanceof IAbsSecurityManager) {
                IAbsSecurityManager asm = (IAbsSecurityManager)rsm;
                List<String> logicalRoles = asm.getLogicalRoles(systemRole.getName());
                if (systemRole instanceof IUIAbsRole) {
                    ((IUIAbsRole)systemRole).setLogicalRoles(logicalRoles);
                    continue;
                }
                throw new IllegalStateException();
            }
            throw new IllegalStateException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addLogicalRole(String logicalRole) {
        IUIRole role = this.getSelectedRole();
        if (role != null) {
            if (!(role instanceof IUIAbsRole)) throw new IllegalStateException();
            ((IUIAbsRole)role).addLogicalRole(logicalRole);
            return;
        } else {
            role = this.getSelectedSystemRole();
            if (!(role instanceof IUIAbsRole)) throw new IllegalStateException();
            ((IUIAbsRole)role).addLogicalRole(logicalRole);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeLogicalRole(String logicalRole) {
        IUIRole role = this.getSelectedRole();
        if (role != null) {
            if (!(role instanceof IUIAbsRole)) throw new IllegalStateException();
            ((IUIAbsRole)role).removeLogicalRole(logicalRole);
            return;
        } else {
            role = this.getSelectedSystemRole();
            if (!(role instanceof IUIAbsRole)) throw new IllegalStateException();
            ((IUIAbsRole)role).removeLogicalRole(logicalRole);
        }
    }
}

