/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.controller;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.UnifiedRepositoryLockService;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.repository.pur.PurRepositoryDialog;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.custom.DialogConstant;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class SpoonLockController
extends AbstractXulEventHandler
implements Serializable {
    private static final long serialVersionUID = -8466323408581425803L;
    private static final Class<?> PKG = PurRepositoryDialog.class;
    private ILockService service;
    private EngineMetaInterface workingMeta = null;
    private BindingFactory bindingFactory = null;
    private boolean tabBound = false;
    private boolean isCreateAllowed = false;
    private boolean isLockingAllowed = false;
    private Shell shell;
    private static Log log = LogFactory.getLog(SpoonLockController.class);
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString((Class)PKG, (String)key, (String[])new String[0]);
        }
    };

    public String getName() {
        return "spoonLockController";
    }

    public void lockContent() throws Exception {
        try {
            if (this.workingMeta != null && this.workingMeta.getObjectId() != null && this.supportsLocking(Spoon.getInstance().getRepository())) {
                if (!this.tabBound) {
                    this.bindingFactory.createBinding((Object)this, "activeMetaUnlocked", (Object)Spoon.getInstance().delegates.tabs.findTabMapEntry((Object)this.workingMeta).getTabItem(), "image", new BindingConvertor[]{new BindingConvertor<Boolean, Image>(){

                        public Image sourceToTarget(Boolean activeMetaUnlocked) {
                            if (activeMetaUnlocked.booleanValue()) {
                                if (SpoonLockController.this.workingMeta instanceof TransMeta) {
                                    return GUIResource.getInstance().getImageTransGraph();
                                }
                                if (SpoonLockController.this.workingMeta instanceof JobMeta) {
                                    return GUIResource.getInstance().getImageJobGraph();
                                }
                            } else {
                                return GUIResource.getInstance().getImageLocked();
                            }
                            return null;
                        }

                        public Boolean targetToSource(Image arg0) {
                            return false;
                        }
                    }});
                    this.tabBound = true;
                }
                if (this.fetchRepositoryLock(this.workingMeta) == null) {
                    XulPromptBox lockNotePrompt = this.promptLockMessage(this.document, this.messages, null);
                    lockNotePrompt.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

                        public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                            if (!status.equals((Object)XulDialogCallback.Status.CANCEL)) {
                                try {
                                    if (SpoonLockController.this.workingMeta instanceof TransMeta) {
                                        SpoonLockController.this.getService(Spoon.getInstance().getRepository()).lockTransformation(SpoonLockController.this.workingMeta.getObjectId(), value);
                                    } else if (SpoonLockController.this.workingMeta instanceof JobMeta) {
                                        SpoonLockController.this.getService(Spoon.getInstance().getRepository()).lockJob(SpoonLockController.this.workingMeta.getObjectId(), value);
                                    }
                                    SpoonLockController.this.firePropertyChange("activeMetaUnlocked", true, false);
                                    XulDomContainer container = SpoonLockController.this.getXulDomContainer();
                                    XulMenuitem lockMenuItem = (XulMenuitem)container.getDocumentRoot().getElementById("lock-context-lock");
                                    lockMenuItem.setSelected(true);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                XulDomContainer container = SpoonLockController.this.getXulDomContainer();
                                XulMenuitem lockMenuItem = (XulMenuitem)container.getDocumentRoot().getElementById("lock-context-lock");
                                lockMenuItem.setSelected(false);
                            }
                        }

                        public void onError(XulComponent component, Throwable err) {
                            throw new RuntimeException(err);
                        }
                    });
                    lockNotePrompt.open();
                } else {
                    if (this.workingMeta instanceof TransMeta) {
                        this.getService(Spoon.getInstance().getRepository()).unlockTransformation(this.workingMeta.getObjectId());
                    } else if (this.workingMeta instanceof JobMeta) {
                        this.getService(Spoon.getInstance().getRepository()).unlockJob(this.workingMeta.getObjectId());
                    }
                    this.firePropertyChange("activeMetaUnlocked", false, true);
                }
            } else if (this.workingMeta != null && this.workingMeta.getObjectId() == null && this.supportsLocking(Spoon.getInstance().getRepository())) {
                XulDomContainer container = this.getXulDomContainer();
                XulMenuitem lockMenuItem = (XulMenuitem)container.getDocumentRoot().getElementById("lock-context-lock");
                lockMenuItem.setSelected(false);
                XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                msgBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                msgBox.setMessage(BaseMessages.getString(PKG, (String)"LockController.SaveBeforeLock", (String[])new String[0]));
                msgBox.setModalParent((Object)this.shell);
                msgBox.open();
            } else {
                XulDomContainer container = this.getXulDomContainer();
                XulMenuitem lockMenuItem = (XulMenuitem)container.getDocumentRoot().getElementById("lock-context-lock");
                lockMenuItem.setSelected(false);
                XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                msgBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
                msgBox.setMessage(BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]));
                msgBox.setModalParent((Object)this.shell);
                msgBox.open();
            }
        }
        catch (Throwable th) {
            log.error((Object)BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]), th);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]), th);
        }
    }

    public void viewLockNote() throws Exception {
        if (this.workingMeta != null && this.supportsLocking(Spoon.getInstance().getRepository())) {
            try {
                RepositoryLock repoLock = this.fetchRepositoryLock(this.workingMeta);
                if (repoLock != null) {
                    XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                    msgBox.setTitle(BaseMessages.getString(PKG, (String)"PurRepository.LockNote.Title", (String[])new String[0]));
                    msgBox.setMessage(repoLock.getMessage());
                    msgBox.setModalParent((Object)this.shell);
                    msgBox.open();
                }
            }
            catch (Throwable th) {
                log.error((Object)BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]), th);
                new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]), th);
            }
        } else {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]));
            msgBox.setMessage(BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]));
            msgBox.setModalParent((Object)this.shell);
            msgBox.open();
        }
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        super.setXulDomContainer(xulDomContainer);
        this.init();
    }

    public boolean isActiveMetaUnlocked() {
        try {
            return this.fetchRepositoryLock(this.workingMeta) == null;
        }
        catch (KettleException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init() {
        try {
            if (Spoon.getInstance().getRepository() != null && Spoon.getInstance().getRepository().hasService(IAbsSecurityProvider.class)) {
                IAbsSecurityProvider securityService = (IAbsSecurityProvider)Spoon.getInstance().getRepository().getService(IAbsSecurityProvider.class);
                this.setCreateAllowed(this.allowedActionsContains(securityService, "org.pentaho.repository.create"));
            }
            this.shell = ((Spoon)SpoonFactory.getInstance()).getShell();
            XulDomContainer container = this.getXulDomContainer();
            this.bindingFactory = new DefaultBindingFactory();
            this.bindingFactory.setDocument(container.getDocumentRoot());
            this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
            this.bindingFactory.createBinding((Object)this, "activeMetaUnlocked", "lock-context-locknotes", "disabled", new BindingConvertor[0]);
            this.bindingFactory.createBinding((Object)this, "lockingNotAllowed", "lock-context-lock", "disabled", new BindingConvertor[0]);
            if (container.getEventHandlers().containsKey("transgraph")) {
                this.workingMeta = ((TransGraph)container.getEventHandler("transgraph")).getMeta();
            } else if (container.getEventHandlers().containsKey("jobgraph")) {
                this.workingMeta = ((JobGraph)container.getEventHandler("jobgraph")).getMeta();
            }
            RepositoryLock repoLock = this.fetchRepositoryLock(this.workingMeta);
            if (repoLock != null) {
                XulMenuitem lockMenuItem = (XulMenuitem)container.getDocumentRoot().getElementById("lock-context-lock");
                lockMenuItem.setSelected(true);
                if (Spoon.getInstance().getRepository() instanceof PurRepository) {
                    this.setLockingAllowed(new UnifiedRepositoryLockService(((PurRepository)Spoon.getInstance().getRepository()).getUnderlyingRepository()).canUnlockFileById(this.workingMeta.getObjectId()));
                } else {
                    this.setLockingAllowed(repoLock.getLogin().equalsIgnoreCase(Spoon.getInstance().getRepository().getUserInfo().getLogin()));
                }
            } else {
                this.setLockingAllowed(true);
            }
            this.firePropertyChange("activeMetaUnlocked", null, repoLock == null);
        }
        catch (Exception e) {
            log.error((Object)BaseMessages.getString(PKG, (String)"LockController.NoLockingSupport", (String[])new String[0]), (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), e.getMessage(), e);
        }
    }

    public boolean isCreateAllowed() {
        return this.isCreateAllowed;
    }

    public void setCreateAllowed(boolean isCreateAllowed) {
        this.isCreateAllowed = isCreateAllowed;
        this.firePropertyChange("createAllowed", null, isCreateAllowed);
    }

    public boolean isLockingAllowed() {
        return this.isLockingAllowed;
    }

    public boolean isLockingNotAllowed() {
        return !this.isLockingAllowed;
    }

    public void setLockingAllowed(boolean isLockingAllowed) {
        this.isLockingAllowed = isLockingAllowed;
        this.firePropertyChange("lockingNotAllowed", null, !isLockingAllowed);
    }

    private boolean allowedActionsContains(IAbsSecurityProvider service, String action) throws KettleException {
        List<String> allowedActions = service.getAllowedActions("org.pentaho");
        for (String actionName : allowedActions) {
            if (action == null || !action.equals(actionName)) continue;
            return true;
        }
        return false;
    }

    protected RepositoryLock fetchRepositoryLock(EngineMetaInterface meta) throws KettleException {
        RepositoryLock result = null;
        if (meta != null && meta.getObjectId() != null) {
            if (meta instanceof TransMeta) {
                result = this.getService(Spoon.getInstance().getRepository()).getTransformationLock(meta.getObjectId());
            } else if (meta instanceof JobMeta) {
                result = this.getService(Spoon.getInstance().getRepository()).getJobLock(meta.getObjectId());
            }
        }
        return result;
    }

    private XulPromptBox promptLockMessage(Document document, ResourceBundle messages, String defaultMessage) throws XulException {
        XulPromptBox prompt = (XulPromptBox)document.createElement("promptbox");
        prompt.setModalParent((Object)this.shell);
        prompt.setTitle(BaseMessages.getString(PKG, (String)"RepositoryExplorer.LockMessage.Title", (String[])new String[0]));
        prompt.setButtons((Object[])new DialogConstant[]{DialogConstant.OK, DialogConstant.CANCEL});
        prompt.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorer.LockMessage.Label", (String[])new String[0]));
        prompt.setValue(defaultMessage == null ? BaseMessages.getString(PKG, (String)"RepositoryExplorer.DefaultLockMessage", (String[])new String[0]) : defaultMessage);
        return prompt;
    }

    private ILockService getService(Repository repository) throws KettleException {
        if (this.service == null) {
            if (repository != null && repository.hasService(ILockService.class)) {
                return (ILockService)repository.getService(ILockService.class);
            }
            throw new IllegalStateException();
        }
        return this.service;
    }

    private boolean supportsLocking(Repository repository) throws KettleException {
        return repository.hasService(ILockService.class);
    }
}

