/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositoryLocation;
import org.pentaho.di.repository.pur.PurRepositoryMeta;
import org.pentaho.di.ui.repository.pur.IRepositoryConfigDialogCallback;
import org.pentaho.di.ui.repository.pur.PurRepositoryDialog;
import org.pentaho.di.ui.repository.pur.model.RepositoryConfigModel;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class RepositoryConfigController
extends AbstractXulEventHandler
implements Serializable {
    private static final long serialVersionUID = 1882563488501980590L;
    public static final String PLUGIN_PROPERTIES_FILE = "plugins/pdi-pur-plugin/plugin.properties";
    public static final String DEFAULT_URL = "default-url";
    private XulDialog repositoryConfigDialog;
    private XulTextbox url;
    private XulTextbox name;
    private XulTextbox id;
    private XulCheckbox modificationComments;
    private XulButton okButton;
    private RepositoryConfigModel model;
    private BindingFactory bf;
    private IRepositoryConfigDialogCallback callback;
    private RepositoryMeta repositoryMeta;
    private ResourceBundle messages;
    private XulMessageBox messageBox;

    public String getName() {
        return "repositoryConfigController";
    }

    public void init() throws ControllerInitializationException {
        this.bf = new DefaultBindingFactory();
        this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
        try {
            this.messageBox = (XulMessageBox)this.document.createElement("messagebox");
        }
        catch (Throwable th) {
            throw new ControllerInitializationException(th);
        }
        this.model = new RepositoryConfigModel();
        if (this.bf != null) {
            this.createBindings();
        }
        this.initializeModel();
    }

    private void createBindings() {
        this.repositoryConfigDialog = (XulDialog)this.document.getElementById("repository-config-dialog");
        this.url = (XulTextbox)this.document.getElementById("repository-url");
        this.name = (XulTextbox)this.document.getElementById("repository-name");
        this.id = (XulTextbox)this.document.getElementById("repository-id");
        this.modificationComments = (XulCheckbox)this.document.getElementById("repository-modification-comments");
        this.okButton = (XulButton)this.document.getElementById("repository-config-dialog_accept");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.model, "url", (Object)this.url, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.model, "name", (Object)this.name, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.model, "id", (Object)this.id, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.model, "modificationComments", (Object)this.modificationComments, "checked", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.model, "valid", (Object)this.okButton, "!disabled", new BindingConvertor[0]);
    }

    public void ok() {
        if (this.repositoryMeta instanceof PurRepositoryMeta) {
            this.repositoryMeta.setName(this.model.getName());
            this.repositoryMeta.setDescription(this.model.getId());
            String url = this.model.getUrl();
            String urlTrim = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            PurRepositoryLocation location = new PurRepositoryLocation(urlTrim);
            ((PurRepositoryMeta)this.repositoryMeta).setRepositoryLocation(location);
            ((PurRepositoryMeta)this.repositoryMeta).setVersionCommentMandatory(this.model.isModificationComments());
            this.getCallback().onSuccess((PurRepositoryMeta)this.repositoryMeta);
        } else {
            this.getCallback().onError(new IllegalStateException(BaseMessages.getString(PurRepositoryDialog.class, (String)"RepositoryConfigDialog.ERROR_0001_NotAnInstanceOfPurRepositoryMeta", (String[])new String[0])));
        }
    }

    public void cancel() {
        if (!this.repositoryConfigDialog.isHidden()) {
            this.repositoryConfigDialog.hide();
            this.getCallback().onCancel();
        }
    }

    public void test() {
        String url = this.model.getUrl() + (this.model.getUrl().endsWith("/") ? "" : "/") + "webservices/unifiedRepository?wsdl";
        try {
            Service service = Service.create((URL)new URL(url), (QName)new QName("http://www.pentaho.org/ws/1.0", "unifiedRepository"));
            if (service != null) {
                IUnifiedRepositoryJaxwsWebService repoWebService = (IUnifiedRepositoryJaxwsWebService)service.getPort(IUnifiedRepositoryJaxwsWebService.class);
                if (repoWebService != null) {
                    this.messageBox.setTitle(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Success", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PurRepositoryDialog.class, (String)"RepositoryConfigDialog.RepositoryUrlTestPassed", (String[])new String[0]));
                    this.messageBox.open();
                } else {
                    this.messageBox.setTitle(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Error", (String[])new String[0]));
                    this.messageBox.setAcceptLabel(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Ok", (String[])new String[0]));
                    this.messageBox.setMessage(BaseMessages.getString(PurRepositoryDialog.class, (String)"RepositoryConfigDialog.RepositoryUrlTestFailed", (String[])new String[0]));
                    this.messageBox.open();
                }
            } else {
                this.messageBox.setTitle(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Error", (String[])new String[0]));
                this.messageBox.setAcceptLabel(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Ok", (String[])new String[0]));
                this.messageBox.setMessage(BaseMessages.getString(PurRepositoryDialog.class, (String)"RepositoryConfigDialog.RepositoryUrlTestFailed", (String[])new String[0]));
                this.messageBox.open();
            }
        }
        catch (Exception e) {
            this.messageBox.setTitle(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Error", (String[])new String[0]));
            this.messageBox.setAcceptLabel(BaseMessages.getString(PurRepositoryDialog.class, (String)"Dialog.Ok", (String[])new String[0]));
            this.messageBox.setMessage(BaseMessages.getString(PurRepositoryDialog.class, (String)"RepositoryConfigDialog.RepositoryUrlTestFailedMessage", (String[])new String[]{e.getLocalizedMessage()}));
            this.messageBox.open();
        }
    }

    private String getDefaultUrl() {
        String returnValue = "";
        FileInputStream fis = null;
        Properties properties = null;
        try {
            File file = new File(PLUGIN_PROPERTIES_FILE);
            fis = new FileInputStream(file);
        }
        catch (IOException e1) {
            return returnValue;
        }
        if (null != fis) {
            properties = new Properties();
            try {
                properties.load(fis);
            }
            catch (IOException e) {
                return returnValue;
            }
        }
        if (properties != null) {
            returnValue = properties.getProperty(DEFAULT_URL, "");
        }
        return returnValue;
    }

    public IRepositoryConfigDialogCallback getCallback() {
        return this.callback;
    }

    public void setCallback(IRepositoryConfigDialogCallback callback) {
        this.callback = callback;
    }

    public void setRepositoryMeta(RepositoryMeta repositoryMeta) {
        this.repositoryMeta = repositoryMeta;
    }

    public void updateModificationComments() {
        this.model.setModificationComments(this.modificationComments.isChecked());
    }

    private void initializeModel() {
        PurRepositoryMeta purRepositoryMeta = null;
        if (this.repositoryMeta != null && this.repositoryMeta instanceof PurRepositoryMeta) {
            purRepositoryMeta = (PurRepositoryMeta)this.repositoryMeta;
            this.model.setName(purRepositoryMeta.getName());
            this.model.setId(purRepositoryMeta.getDescription());
            PurRepositoryLocation location = purRepositoryMeta.getRepositoryLocation();
            if (location != null) {
                this.model.setUrl(location.getUrl());
            } else {
                this.model.setUrl(this.getDefaultUrl());
            }
        } else {
            this.model.setModificationComments(true);
        }
    }

    public ResourceBundle getMessages() {
        return this.messages;
    }

    public void setMessages(ResourceBundle messages) {
        this.messages = messages;
    }
}

