/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.pur;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PurRepositoryRevisionBrowserDialog
implements RepositoryRevisionBrowserDialogInterface,
Serializable {
    private static final long serialVersionUID = -1596062300653831848L;
    private static Class<?> PKG = PurRepositoryRevisionBrowserDialog.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wOpen;
    private Button wClose;
    private Listener lsOpen;
    private Listener lsClose;
    private Display display;
    private Shell shell;
    private PropsUI props;
    protected Repository repository;
    private IRevisionService revisionService;
    private RepositoryElementInterface element;
    private List<ObjectRevision> revisions;
    private String elementDescription;
    private String selectedRevision;

    public PurRepositoryRevisionBrowserDialog(Shell parent, int style, Repository repository, RepositoryElementInterface element) {
        this.display = parent.getDisplay();
        this.props = PropsUI.getInstance();
        this.repository = repository;
        this.element = element;
        try {
            if (!repository.hasService(IRevisionService.class)) {
                throw new IllegalStateException();
            }
            this.revisionService = (IRevisionService)repository.getService(IRevisionService.class);
        }
        catch (KettleException e) {
            throw new IllegalStateException(e);
        }
        String name = element.getRepositoryElementType().toString() + " " + element.getRepositoryDirectory().getPath();
        if (!name.endsWith("/")) {
            name = name + "/";
        }
        this.elementDescription = name = name + element.getName();
        this.shell = new Shell(this.display, style | 0x860 | 0x10 | 0x400 | 0x80);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.Dialog.Main.Title", (String[])new String[0]));
    }

    public String open() {
        try {
            this.props.setLook((Control)this.shell);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            formLayout.marginHeight = 5;
            this.shell.setLayout((Layout)formLayout);
            this.shell.setImage(GUIResource.getInstance().getImageVersionBrowser());
            int margin = 4;
            this.revisions = this.revisionService.getRevisions(this.element);
            if (this.revisions == null || this.revisions.size() == 0) {
                ShowMessageDialog dialog = new ShowMessageDialog(this.shell, 40, BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.NoRevisions.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.NoRevisions.Message", (String[])new String[0]));
                dialog.open();
                this.shell.dispose();
                return null;
            }
            this.wlFields = new Label((Composite)this.shell, 16384);
            this.wlFields.setText("Revision history of " + this.elementDescription);
            this.props.setLook((Control)this.wlFields);
            this.fdlFields = new FormData();
            this.fdlFields.left = new FormAttachment(0, 0);
            this.fdlFields.right = new FormAttachment(100, 0);
            this.fdlFields.top = new FormAttachment(0, margin);
            this.wlFields.setLayoutData((Object)this.fdlFields);
            ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.Columns.Revision.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.Columns.Revision.Comment", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.Columns.Revision.Date", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PurRepositoryRevisionBrowserDialog.Columns.Revision.Login", (String[])new String[0]), 1, false, true)};
            this.wFields = new TableView((VariableSpace)new Variables(), (Composite)this.shell, 67588, colinf, 0, null, this.props);
            this.wFields.setReadonly(true);
            this.fdFields = new FormData();
            this.fdFields.left = new FormAttachment(0, 0);
            this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
            this.fdFields.right = new FormAttachment(100, 0);
            this.fdFields.bottom = new FormAttachment(100, -50);
            this.wFields.setLayoutData((Object)this.fdFields);
            this.wFields.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String[] item;
                    int index = PurRepositoryRevisionBrowserDialog.this.wFields.getSelectionIndex();
                    if (index >= 0 && (item = PurRepositoryRevisionBrowserDialog.this.wFields.getItem(index)) != null && item.length > 0) {
                        PurRepositoryRevisionBrowserDialog.this.selectedRevision = item[0];
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    PurRepositoryRevisionBrowserDialog.this.ok();
                }
            });
            this.wOpen = new Button((Composite)this.shell, 8);
            this.wOpen.setText(BaseMessages.getString((String)"System.Button.Open"));
            this.lsOpen = new Listener(){

                public void handleEvent(Event e) {
                    PurRepositoryRevisionBrowserDialog.this.ok();
                }
            };
            this.wOpen.addListener(13, this.lsOpen);
            this.wClose = new Button((Composite)this.shell, 8);
            this.wClose.setText(BaseMessages.getString((String)"System.Button.Close"));
            this.lsClose = new Listener(){

                public void handleEvent(Event e) {
                    PurRepositoryRevisionBrowserDialog.this.cancel();
                }
            };
            this.wClose.addListener(13, this.lsClose);
            BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOpen, this.wClose}, (int)margin, null);
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    PurRepositoryRevisionBrowserDialog.this.cancel();
                }
            });
            this.getData();
            BaseStepDialog.setSize((Shell)this.shell);
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
            return this.selectedRevision;
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error browsing versions", "There was an error browsing the version history of element " + this.element, e);
            return null;
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wFields.clearAll(false);
        for (ObjectRevision revision : this.revisions) {
            this.wFields.add(new String[]{revision.getName(), revision.getComment(), XMLHandler.date2string((Date)revision.getCreationDate()), revision.getLogin()});
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.selectedRevision = null;
        this.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

