/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.ui.repository.pur.PurRepositoryDialog;
import org.pentaho.di.ui.repository.pur.controller.SpoonLockController;
import org.pentaho.di.ui.repository.pur.controller.SpoonMenuLockController;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.UIEEObjectRegistery;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.AbsSecurityManagerUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.AbsSecurityProviderUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.controller.SpoonMenuABSController;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.abs.model.UIAbsRepositoryRole;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEEDatabaseConnection;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEEJob;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEERepositoryDirectory;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEERepositoryUser;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.model.UIEETransformation;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.AclUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.ConnectionAclUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.ManageRolesUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.RepositoryLockUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.RevisionsUISupport;
import org.pentaho.di.ui.repository.pur.repositoryexplorer.uisupport.TrashUISupport;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityManager;
import org.pentaho.di.ui.repository.pur.services.IAbsSecurityProvider;
import org.pentaho.di.ui.repository.pur.services.IAclService;
import org.pentaho.di.ui.repository.pur.services.IConnectionAclService;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.di.ui.repository.pur.services.IRevisionService;
import org.pentaho.di.ui.repository.pur.services.IRoleSupportSecurityManager;
import org.pentaho.di.ui.repository.pur.services.ITrashService;
import org.pentaho.di.ui.repository.repositoryexplorer.UISupportRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.spoon.ChangedWarningDialog;
import org.pentaho.di.ui.spoon.ChangedWarningInterface;
import org.pentaho.di.ui.spoon.ISpoonMenuController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPlugin;
import org.pentaho.di.ui.spoon.SpoonPluginCategories;
import org.pentaho.di.ui.spoon.SpoonPluginInterface;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegateRegistry;
import org.pentaho.di.ui.spoon.delegates.SpoonEEJobDelegate;
import org.pentaho.di.ui.spoon.delegates.SpoonEETransformationDelegate;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;

@SpoonPlugin(id="EESpoonPlugin", image="")
@SpoonPluginCategories(value={"spoon", "trans-graph", "job-graph", "repository-explorer"})
public class EESpoonPlugin
implements SpoonPluginInterface,
SpoonLifecycleListener,
Serializable {
    private static final long serialVersionUID = -5672306503357631444L;
    protected static Class<?> PKG = EESpoonPlugin.class;
    protected XulDomContainer spoonXulContainer = null;
    protected ResourceBundle messages = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
        }
    };

    public SpoonLifecycleListener getLifecycleListener() {
        return this;
    }

    public SpoonPerspective getPerspective() {
        return null;
    }

    public void onEvent(SpoonLifecycleListener.SpoonLifeCycleEvent evt) {
        try {
            switch (evt) {
                case MENUS_REFRESHED: {
                    break;
                }
                case REPOSITORY_CHANGED: {
                    this.doOnSecurityUpdate();
                    break;
                }
                case REPOSITORY_CONNECTED: {
                    final Spoon spoon = this.getSpoonInstance();
                    if (spoon != null) {
                        spoon.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    EESpoonPlugin.this.warnClosingOfOpenTabsBasedOnPerms(spoon);
                                }
                                catch (KettleException kettleException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    this.doOnSecurityUpdate();
                    break;
                }
                case REPOSITORY_DISCONNECTED: {
                    this.updateMenuState(true, true);
                    break;
                }
                case STARTUP: {
                    this.registerUISuppportForRepositoryExplorer();
                    break;
                }
                case SHUTDOWN: {
                    break;
                }
            }
        }
        catch (KettleException e) {
            try {
                this.initMainSpoonContainer();
                XulMessageBox messageBox = (XulMessageBox)this.spoonXulContainer.getDocumentRoot().createElement("messagebox");
                messageBox.setTitle(BaseMessages.getString(PKG, (String)"Dialog.Success", (String[])new String[0]));
                messageBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString(PKG, (String)"AbsController.RoleActionPermission.Success", (String[])new String[0]));
                messageBox.open();
            }
            catch (Exception ex) {
                e.printStackTrace();
            }
        }
    }

    private void doOnSecurityUpdate() throws KettleException {
        this.initMainSpoonContainer();
        Repository repository = this.getSpoonInstance().getRepository();
        if (repository != null && repository.hasService(IRoleSupportSecurityManager.class)) {
            UIObjectRegistry.getInstance().registerUIRepositoryUserClass(UIEERepositoryUser.class);
        } else {
            UIObjectRegistry.getInstance().registerUIRepositoryUserClass(UIObjectRegistry.DEFAULT_UIREPOSITORYUSER_CLASS);
        }
        if (repository != null && repository.hasService(IAclService.class)) {
            UIObjectRegistry.getInstance().registerUIRepositoryDirectoryClass(UIEERepositoryDirectory.class);
            UIObjectRegistry.getInstance().registerUIDatabaseConnectionClass(UIEEDatabaseConnection.class);
        } else {
            UIObjectRegistry.getInstance().registerUIRepositoryDirectoryClass(UIObjectRegistry.DEFAULT_UIDIR_CLASS);
        }
        if (repository != null && repository.hasService(IAbsSecurityProvider.class)) {
            UIEEObjectRegistery.getInstance().registerUIRepositoryRoleClass(UIAbsRepositoryRole.class);
            IAbsSecurityProvider securityProvider = (IAbsSecurityProvider)repository.getService(IAbsSecurityProvider.class);
            this.enablePermission(securityProvider);
        }
        if (repository.hasService(ILockService.class)) {
            UIObjectRegistry.getInstance().registerUIJobClass(UIEEJob.class);
            UIObjectRegistry.getInstance().registerUITransformationClass(UIEETransformation.class);
            SpoonDelegateRegistry.getInstance().registerSpoonJobDelegateClass(SpoonEEJobDelegate.class);
            SpoonDelegateRegistry.getInstance().registerSpoonTransDelegateClass(SpoonEETransformationDelegate.class);
        } else {
            UIObjectRegistry.getInstance().registerUIJobClass(UIObjectRegistry.DEFAULT_UIJOB_CLASS);
            UIObjectRegistry.getInstance().registerUITransformationClass(UIObjectRegistry.DEFAULT_UITRANS_CLASS);
            SpoonDelegateRegistry.getInstance().registerSpoonJobDelegateClass(SpoonDelegateRegistry.DEFAULT_SPOONJOBDELEGATE_CLASS);
            SpoonDelegateRegistry.getInstance().registerSpoonTransDelegateClass(SpoonDelegateRegistry.DEFAULT_SPOONTRANSDELEGATE_CLASS);
        }
    }

    private void enablePermission(IAbsSecurityProvider securityProvider) throws KettleException {
        boolean createPermitted = securityProvider.isAllowed("org.pentaho.repository.create");
        boolean executePermitted = securityProvider.isAllowed("org.pentaho.repository.execute");
        boolean adminPermitted = securityProvider.isAllowed("org.pentaho.security.administerSecurity");
        this.enablePermission(createPermitted, executePermitted, adminPermitted);
    }

    private void enablePermission(boolean createPermitted, boolean executePermitted, boolean adminPermitted) {
        this.updateMenuState(createPermitted, executePermitted);
        EESpoonPlugin.updateChangedWarningDialog(createPermitted);
    }

    private void registerUISuppportForRepositoryExplorer() {
        UISupportRegistery.getInstance().registerUISupport(IRevisionService.class, RevisionsUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(IAclService.class, AclUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(IConnectionAclService.class, ConnectionAclUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(IRoleSupportSecurityManager.class, ManageRolesUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(IAbsSecurityManager.class, AbsSecurityManagerUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(IAbsSecurityProvider.class, AbsSecurityProviderUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(ITrashService.class, TrashUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(ILockService.class, RepositoryLockUISupport.class);
    }

    public void applyToContainer(String category, XulDomContainer container) throws XulException {
        container.registerClassLoader((Object)this.getClass().getClassLoader());
        if (category.equals("spoon")) {
            this.getSpoonInstance().addSpoonMenuController((ISpoonMenuController)new SpoonMenuABSController());
            this.getSpoonInstance().addSpoonMenuController((ISpoonMenuController)new SpoonMenuLockController());
        } else if (category.equals("trans-graph") || category.equals("job-graph")) {
            if (this.getSpoonInstance() != null && this.getSpoonInstance().getRepository() != null && this.getSpoonInstance().getRepository() instanceof PurRepository) {
                container.getDocumentRoot().addOverlay("org/pentaho/di/ui/repository/pur/xul/spoon-lock-overlay.xul");
                container.addEventHandler((XulEventHandler)new SpoonLockController());
            }
            try {
                IAbsSecurityProvider securityProvider;
                Repository repository = this.getSpoonInstance().getRepository();
                if (repository != null && (securityProvider = (IAbsSecurityProvider)repository.getService(IAbsSecurityProvider.class)) != null) {
                    this.enablePermission(securityProvider);
                }
            }
            catch (KettleException e) {
                e.printStackTrace();
            }
        } else if (category.equals("repository-explorer")) {
            try {
                Repository repository = this.getSpoonInstance().getRepository();
                IAbsSecurityProvider securityProvider = null;
                if (repository != null) {
                    securityProvider = (IAbsSecurityProvider)repository.getService(IAbsSecurityProvider.class);
                }
                if (securityProvider != null) {
                    boolean createPermitted = securityProvider.isAllowed("org.pentaho.repository.create");
                    boolean executePermitted = securityProvider.isAllowed("org.pentaho.repository.execute");
                    container.getDocumentRoot().getElementById("folder-context-export").setDisabled(!createPermitted || !executePermitted);
                }
            }
            catch (KettleException e) {
                e.printStackTrace();
            }
        }
    }

    void updateMenuState(boolean createPermitted, boolean executePermitted) {
        Document doc = this.getDocumentRoot();
        if (doc != null) {
            ((XulMenuitem)doc.getElementById("process-run")).setDisabled(!executePermitted);
            XulToolbarbutton transRunButton = (XulToolbarbutton)doc.getElementById("trans-run");
            if (transRunButton != null) {
                transRunButton.setDisabled(!executePermitted);
            }
            ((XulMenuitem)doc.getElementById("trans-preview")).setDisabled(!executePermitted);
            ((XulMenuitem)doc.getElementById("trans-debug")).setDisabled(!executePermitted);
            ((XulMenuitem)doc.getElementById("trans-replay")).setDisabled(!executePermitted);
            ((XulMenuitem)doc.getElementById("trans-verify")).setDisabled(!executePermitted);
            ((XulMenuitem)doc.getElementById("trans-impact")).setDisabled(!executePermitted);
            ((XulMenuitem)doc.getElementById("trans-get-sql")).setDisabled(!executePermitted);
            ((XulMenu)doc.getElementById("trans-last")).setDisabled(!executePermitted);
            if (doc.getElementById("trans-schedule") != null) {
                ((XulMenuitem)doc.getElementById("trans-schedule")).setDisabled(!executePermitted);
            }
            ((XulToolbarbutton)doc.getElementById("toolbar-file-new")).setDisabled(!createPermitted);
            ((XulToolbarbutton)doc.getElementById("toolbar-file-save")).setDisabled(!createPermitted);
            ((XulToolbarbutton)doc.getElementById("toolbar-file-save-as")).setDisabled(!createPermitted);
            ((XulMenuitem)doc.getElementById("trans-class-new")).setDisabled(!createPermitted);
            ((XulMenuitem)doc.getElementById("job-class-new")).setDisabled(!createPermitted);
            ((XulMenu)doc.getElementById("file-new")).setDisabled(!createPermitted);
            ((XulMenuitem)doc.getElementById("file-save")).setDisabled(!createPermitted);
            ((XulMenuitem)doc.getElementById("file-save-as")).setDisabled(!createPermitted);
            ((XulMenuitem)doc.getElementById("file-close")).setDisabled(!createPermitted);
            boolean exportAllowed = createPermitted && executePermitted;
            ((XulMenu)doc.getElementById("file-export")).setDisabled(!exportAllowed);
            ((XulMenuitem)doc.getElementById("repository-export-all")).setDisabled(!exportAllowed);
            ((XulMenuitem)doc.getElementById("edit-cut-steps")).setDisabled(!exportAllowed);
            ((XulMenuitem)doc.getElementById("edit-copy-steps")).setDisabled(!exportAllowed);
            ((XulMenuitem)doc.getElementById("edit.copy-file")).setDisabled(!exportAllowed);
            ((XulMenuitem)doc.getElementById("edit-paste-steps")).setDisabled(!exportAllowed);
            XulMenuitem transCopyContextMenu = (XulMenuitem)doc.getElementById("trans-graph-entry-copy");
            if (transCopyContextMenu != null) {
                transCopyContextMenu.setDisabled(!exportAllowed);
            }
        }
    }

    public static void updateChangedWarningDialog(boolean overrideDefaultDialogBehavior) {
        if (!overrideDefaultDialogBehavior) {
            ChangedWarningDialog.setInstance((ChangedWarningInterface)new ChangedWarningDialog(){

                public int show() {
                    return this.show(null);
                }

                public int show(String fileName) {
                    XulMessageBox msgBox = null;
                    try {
                        msgBox = this.runXulChangedWarningDialog(fileName);
                        if (fileName != null) {
                            msgBox.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptToSave.Fail.Message.WithParam", (String[])new String[]{fileName}));
                        } else {
                            msgBox.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptToSave.Fail.Message", (String[])new String[0]));
                        }
                        msgBox.setButtons((Object[])new Integer[]{192});
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    int retVal = msgBox.open();
                    if (retVal == 64) {
                        return 128;
                    }
                    return 256;
                }
            });
        } else {
            ChangedWarningDialog.setInstance((ChangedWarningInterface)new ChangedWarningDialog());
        }
    }

    private void warnClosingOfOpenTabsBasedOnPerms(Spoon spoon) throws KettleException {
        Class<PurRepositoryDialog> PKG = PurRepositoryDialog.class;
        Repository repository = spoon.getRepository();
        if (spoon.getActiveMeta() == null) {
            return;
        }
        String warningTitle = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllForce.Connect.Title", (String[])new String[0]);
        String warningText = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllOptionAdditional.Connect.Message", (String[])new String[0]);
        String additionalWarningText = "";
        int buttons = 32;
        IAbsSecurityProvider absSecurityProvider = (IAbsSecurityProvider)repository.getService(IAbsSecurityProvider.class);
        if (absSecurityProvider != null) {
            boolean createPerms = false;
            boolean executePerms = false;
            boolean readPerms = false;
            try {
                createPerms = absSecurityProvider.isAllowed("org.pentaho.repository.create");
                executePerms = absSecurityProvider.isAllowed("org.pentaho.repository.execute");
                readPerms = absSecurityProvider.isAllowed("org.pentaho.repository.read");
            }
            catch (KettleException kettleException) {
                // empty catch block
            }
            if (readPerms && createPerms && executePerms) {
                warningTitle = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllOption.Connect.Title", (String[])new String[0]);
                warningText = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllOption.Connect.Message", (String[])new String[0]);
                buttons = 194;
            } else {
                warningText = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllForce.Connect.Message", (String[])new String[0]);
                if (createPerms) {
                    additionalWarningText = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllForceAdditional.Connect.Message", (String[])new String[0]);
                    buttons = 200;
                } else {
                    additionalWarningText = BaseMessages.getString(PKG, (String)"PurRepository.Dialog.WarnToCloseAllOptionAdditional.Connect.Message", (String[])new String[0]);
                    buttons = 40;
                }
            }
        }
        MessageBox mb = new MessageBox(spoon.getShell(), buttons);
        mb.setMessage(additionalWarningText.length() != 0 ? warningText + "\n\n" + additionalWarningText : warningText);
        mb.setText(warningTitle);
        int isCloseAllFiles = mb.open();
        if (isCloseAllFiles == 64 || isCloseAllFiles == 32) {
            spoon.closeAllFiles();
        }
    }

    private Document getDocumentRoot() {
        this.initMainSpoonContainer();
        if (this.spoonXulContainer != null) {
            return this.spoonXulContainer.getDocumentRoot();
        }
        return null;
    }

    private void initMainSpoonContainer() {
        if (this.getSpoonInstance() != null && this.spoonXulContainer == null && this.getSpoonInstance().getMainSpoonContainer() != null) {
            this.spoonXulContainer = this.getSpoonInstance().getMainSpoonContainer();
        }
    }

    Spoon getSpoonInstance() {
        return Spoon.getInstance();
    }
}

