/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.pur.model.EERoleInfo;
import org.pentaho.di.repository.pur.model.IAbsRole;

public class AbsRoleInfo
extends EERoleInfo
implements IAbsRole,
Serializable {
    private static final long serialVersionUID = -4260995958866269607L;
    private List<String> logicalRoles;

    public AbsRoleInfo() {
        this.logicalRoles = new ArrayList<String>();
    }

    public AbsRoleInfo(String name, String description) {
        super(name, description);
        this.logicalRoles = new ArrayList<String>();
    }

    public AbsRoleInfo(String name, String description, Set<IUser> users, List<String> logicalRoles) {
        super(name, description, users);
        this.logicalRoles = logicalRoles;
    }

    @Override
    public void addLogicalRole(String logicalRole) {
        if (this.logicalRoles == null) {
            this.logicalRoles = new ArrayList<String>();
        }
        if (!this.containsLogicalRole(logicalRole)) {
            this.logicalRoles.add(logicalRole);
        }
    }

    @Override
    public void removeLogicalRole(String logicalRole) {
        if (this.containsLogicalRole(logicalRole)) {
            this.logicalRoles.remove(logicalRole);
        }
    }

    @Override
    public List<String> getLogicalRoles() {
        return this.logicalRoles;
    }

    @Override
    public void setLogicalRoles(List<String> logicalRoles) {
        this.logicalRoles = logicalRoles;
    }

    @Override
    public boolean containsLogicalRole(String logicalRole) {
        if (this.logicalRoles != null) {
            for (String role : this.logicalRoles) {
                if (!role.equals(logicalRole)) continue;
                return true;
            }
        }
        return false;
    }
}

