/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.model.RepositoryLock;
import org.pentaho.di.ui.repository.pur.services.ILockService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;

public class UnifiedRepositoryLockService
implements ILockService {
    private final IUnifiedRepository pur;

    public UnifiedRepositoryLockService(IUnifiedRepository pur) {
        this.pur = pur;
    }

    protected void lockFileById(ObjectId id, String message) throws KettleException {
        this.pur.lockFile((Serializable)((Object)id.getId()), message);
    }

    public RepositoryLock getLock(RepositoryFile file) throws KettleException {
        if (file.isLocked()) {
            return new RepositoryLock((ObjectId)new StringObjectId(file.getId().toString()), file.getLockMessage(), file.getLockOwner(), file.getLockOwner(), file.getLockDate());
        }
        return null;
    }

    protected RepositoryLock getLockById(ObjectId id) throws KettleException {
        try {
            RepositoryFile file = this.pur.getFileById((Serializable)((Object)id.getId()));
            return this.getLock(file);
        }
        catch (Exception e) {
            throw new KettleException("Unable to get lock for object with id [" + id + "]", (Throwable)e);
        }
    }

    protected void unlockFileById(ObjectId id) throws KettleException {
        this.pur.unlockFile((Serializable)((Object)id.getId()));
    }

    @Override
    public RepositoryLock lockJob(ObjectId idJob, String message) throws KettleException {
        this.lockFileById(idJob, message);
        return this.getLockById(idJob);
    }

    @Override
    public void unlockJob(ObjectId idJob) throws KettleException {
        this.unlockFileById(idJob);
    }

    @Override
    public RepositoryLock getJobLock(ObjectId idJob) throws KettleException {
        return this.getLockById(idJob);
    }

    @Override
    public RepositoryLock lockTransformation(ObjectId idTransformation, String message) throws KettleException {
        this.lockFileById(idTransformation, message);
        return this.getLockById(idTransformation);
    }

    @Override
    public void unlockTransformation(ObjectId idTransformation) throws KettleException {
        this.unlockFileById(idTransformation);
    }

    @Override
    public RepositoryLock getTransformationLock(ObjectId idTransformation) throws KettleException {
        return this.getLockById(idTransformation);
    }

    @Override
    public boolean canUnlockFileById(ObjectId id) {
        return this.pur.canUnlockFile((Serializable)((Object)id.getId()));
    }
}

