/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.AbstractDelegate;
import org.pentaho.di.repository.pur.ITransformer;
import org.pentaho.di.repository.pur.PurRepository;
import org.pentaho.di.repository.pur.SharedObjectAssembler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.VersionSummary;
import org.pentaho.platform.api.repository2.unified.data.node.DataNode;
import org.pentaho.platform.api.repository2.unified.data.node.DataProperty;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class DatabaseDelegate
extends AbstractDelegate
implements ITransformer,
SharedObjectAssembler<DatabaseMeta>,
Serializable {
    private static final long serialVersionUID = 1512547938350522165L;
    private static final String PROP_INDEX_TBS = "INDEX_TBS";
    private static final String PROP_DATA_TBS = "DATA_TBS";
    private static final String PROP_SERVERNAME = "SERVERNAME";
    private static final String PROP_PASSWORD = "PASSWORD";
    private static final String PROP_USERNAME = "USERNAME";
    private static final String PROP_PORT = "PORT";
    private static final String PROP_DATABASE_NAME = "DATABASE_NAME";
    private static final String PROP_HOST_NAME = "HOST_NAME";
    private static final String PROP_CONTYPE = "CONTYPE";
    private static final String PROP_TYPE = "TYPE";
    private static final String NODE_ROOT = "databaseMeta";
    private static final String NODE_ATTRIBUTES = "attributes";
    private static final String NODE_POOLING_PROPS = "poolProps";
    private static final String NODE_EXTRA_OPTIONS = "extraOptions";
    private static final String PROP_CONNECT_SQL = "connectionSQL";
    private static final String PROP_INITIAL_POOL_SIZE = "initialPoolSize";
    private static final String PROP_MAX_POOL_SIZE = "maxPoolSize";
    private static final String PROP_IS_POOLING = "isPooling";
    private static final String PROP_IS_FORCING_TO_LOWER = "isForcingLower";
    private static final String PROP_IS_FORCING_TO_UPPER = "isForcingUpper";
    private static final String PROP_IS_QUOTE_FIELDS = "isQuoteFields";
    private static final String PROP_IS_DECIMAL_SEPERATOR = "isUsingDecimalSeperator";
    private static final String PROP_SUPPORT_BOOLEAN_DATA_TYPE = "isSupportBooleanDataType";
    private static final String PROP_SUPPORT_TIMESTAMP_DATA_TYPE = "isSupportTimestampDataType";
    private PurRepository repo;

    public DatabaseDelegate(PurRepository repo) {
        this.repo = repo;
    }

    @Override
    public DataNode elementToDataNode(RepositoryElementInterface element) throws KettleException {
        DatabaseMeta databaseMeta = (DatabaseMeta)element;
        DataNode rootNode = new DataNode(NODE_ROOT);
        rootNode.setProperty(PROP_TYPE, databaseMeta.getPluginId());
        rootNode.setProperty(PROP_CONTYPE, DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()));
        rootNode.setProperty(PROP_HOST_NAME, databaseMeta.getHostname());
        rootNode.setProperty(PROP_DATABASE_NAME, databaseMeta.getDatabaseName());
        rootNode.setProperty(PROP_PORT, (long)Const.toInt((String)databaseMeta.getDatabasePortNumberString(), (int)-1));
        rootNode.setProperty(PROP_USERNAME, databaseMeta.getUsername());
        rootNode.setProperty(PROP_PASSWORD, Encr.encryptPasswordIfNotUsingVariables((String)databaseMeta.getPassword()));
        rootNode.setProperty(PROP_SERVERNAME, databaseMeta.getServername());
        rootNode.setProperty(PROP_DATA_TBS, databaseMeta.getDataTablespace());
        rootNode.setProperty(PROP_INDEX_TBS, databaseMeta.getIndexTablespace());
        rootNode.setProperty(PROP_CONNECT_SQL, this.setNull(databaseMeta.getConnectSQL()));
        rootNode.setProperty(PROP_INITIAL_POOL_SIZE, (long)databaseMeta.getInitialPoolSize());
        rootNode.setProperty(PROP_MAX_POOL_SIZE, (long)databaseMeta.getMaximumPoolSize());
        rootNode.setProperty(PROP_IS_POOLING, databaseMeta.isUsingConnectionPool());
        rootNode.setProperty(PROP_IS_FORCING_TO_LOWER, databaseMeta.isForcingIdentifiersToLowerCase());
        rootNode.setProperty(PROP_IS_FORCING_TO_UPPER, databaseMeta.isForcingIdentifiersToUpperCase());
        rootNode.setProperty(PROP_IS_QUOTE_FIELDS, databaseMeta.isQuoteAllFields());
        rootNode.setProperty(PROP_IS_DECIMAL_SEPERATOR, databaseMeta.isUsingDoubleDecimalAsSchemaTableSeparator());
        rootNode.setProperty(PROP_SUPPORT_BOOLEAN_DATA_TYPE, databaseMeta.supportsBooleanDataType());
        rootNode.setProperty(PROP_SUPPORT_TIMESTAMP_DATA_TYPE, databaseMeta.supportsTimestampDataType());
        if (databaseMeta.getAttributes() != null && !databaseMeta.getAttributes().isEmpty()) {
            this.addNodeToElement(NODE_ATTRIBUTES, rootNode, databaseMeta.getAttributes().entrySet());
        }
        if (databaseMeta.getConnectionPoolingProperties() != null && !databaseMeta.getConnectionPoolingProperties().isEmpty()) {
            this.addNodeToElement(NODE_POOLING_PROPS, rootNode, databaseMeta.getConnectionPoolingProperties().entrySet());
        }
        if (databaseMeta.getExtraOptions() != null && !databaseMeta.getExtraOptions().isEmpty()) {
            this.addNodeToElement(NODE_EXTRA_OPTIONS, rootNode, new HashMap(databaseMeta.getExtraOptions()).entrySet());
        }
        return rootNode;
    }

    private void addNodeToElement(String nodeName, DataNode rootNode, Set<Map.Entry<Object, Object>> attributes) {
        if (attributes == null) {
            return;
        }
        DataNode attrNode = rootNode.addNode(nodeName);
        for (Map.Entry<Object, Object> entry : attributes) {
            String code = (String)entry.getKey();
            String attribute = (String)entry.getValue();
            String escapedCode = RepositoryFilenameUtils.escape((String)code, (List)this.repo.getUnderlyingRepository().getReservedChars());
            attrNode.setProperty(escapedCode, attribute);
        }
    }

    @Override
    public RepositoryElementInterface dataNodeToElement(DataNode rootNode) throws KettleException {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        this.dataNodeToElement(rootNode, (RepositoryElementInterface)databaseMeta);
        return databaseMeta;
    }

    @Override
    public void dataNodeToElement(DataNode rootNode, RepositoryElementInterface element) throws KettleException {
        String attribute;
        String code;
        DatabaseMeta databaseMeta = (DatabaseMeta)element;
        databaseMeta.setDatabaseType(this.getString(rootNode, PROP_TYPE));
        databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)this.getString(rootNode, PROP_CONTYPE)));
        databaseMeta.setHostname(this.getString(rootNode, PROP_HOST_NAME));
        databaseMeta.setDBName(this.getString(rootNode, PROP_DATABASE_NAME));
        databaseMeta.setDBPort(this.getString(rootNode, PROP_PORT));
        databaseMeta.setUsername(this.getString(rootNode, PROP_USERNAME));
        databaseMeta.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getString(rootNode, PROP_PASSWORD)));
        databaseMeta.setServername(this.getString(rootNode, PROP_SERVERNAME));
        databaseMeta.setDataTablespace(this.getString(rootNode, PROP_DATA_TBS));
        databaseMeta.setIndexTablespace(this.getString(rootNode, PROP_INDEX_TBS));
        databaseMeta.setConnectSQL(this.getString(rootNode, PROP_CONNECT_SQL));
        databaseMeta.setInitialPoolSize(this.getInt(rootNode, PROP_INITIAL_POOL_SIZE));
        databaseMeta.setMaximumPoolSize(this.getInt(rootNode, PROP_MAX_POOL_SIZE));
        databaseMeta.setUsingConnectionPool(this.getBoolean(rootNode, PROP_IS_POOLING));
        databaseMeta.setForcingIdentifiersToLowerCase(this.getBoolean(rootNode, PROP_IS_FORCING_TO_LOWER));
        databaseMeta.setForcingIdentifiersToUpperCase(this.getBoolean(rootNode, PROP_IS_FORCING_TO_UPPER));
        databaseMeta.setQuoteAllFields(this.getBoolean(rootNode, PROP_IS_QUOTE_FIELDS));
        databaseMeta.setUsingDoubleDecimalAsSchemaTableSeparator(this.getBoolean(rootNode, PROP_IS_DECIMAL_SEPERATOR));
        databaseMeta.setSupportsBooleanDataType(this.getBoolean(rootNode, PROP_SUPPORT_BOOLEAN_DATA_TYPE));
        databaseMeta.setSupportsTimestampDataType(this.getBoolean(rootNode, PROP_SUPPORT_TIMESTAMP_DATA_TYPE));
        DataNode attrNode = rootNode.getNode(NODE_ATTRIBUTES);
        for (Object property : attrNode.getProperties()) {
            String code2 = property.getName();
            String attribute2 = property.getString();
            String unescapeCode = RepositoryFilenameUtils.unescape((String)code2);
            databaseMeta.getAttributes().put(unescapeCode, Const.NVL((String)attribute2, (String)""));
        }
        attrNode = rootNode.getNode(NODE_POOLING_PROPS);
        if (attrNode != null) {
            Properties properties = new Properties();
            for (DataProperty property : attrNode.getProperties()) {
                code = property.getName();
                attribute = property.getString();
                properties.put(code, attribute == null || attribute.length() == 0 ? "" : attribute);
            }
            databaseMeta.setConnectionPoolingProperties(properties);
        }
        if ((attrNode = rootNode.getNode(NODE_EXTRA_OPTIONS)) != null) {
            for (Object property : attrNode.getProperties()) {
                String databaseTypeCode = property.getName().substring(0, property.getName().indexOf(46));
                code = property.getName().replace(databaseTypeCode + ".", "");
                attribute = property.getString();
                databaseMeta.addExtraOption(databaseTypeCode, code, attribute == null || attribute.length() == 0 ? "" : attribute);
            }
        }
    }

    public Repository getRepository() {
        return this.repo;
    }

    @Override
    public DatabaseMeta assemble(RepositoryFile file, NodeRepositoryFileData data, VersionSummary version) throws KettleException {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.dataNodeToElement(data.getNode());
        String fileName = file.getName();
        if (fileName.endsWith(".kdb")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        databaseMeta.setChangedDate(file.getLastModifiedDate());
        databaseMeta.setName(fileName);
        databaseMeta.setDisplayName(file.getTitle());
        databaseMeta.setObjectId((ObjectId)new StringObjectId(file.getId().toString()));
        databaseMeta.setObjectRevision(this.repo.createObjectRevision(version));
        databaseMeta.clearChanged();
        return databaseMeta;
    }
}

