/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.pentaho.di.repository.pur.ActiveCacheLoader;
import org.pentaho.di.repository.pur.ActiveCacheResult;

public class ActiveCacheCallable<Key, Value>
implements Callable<ActiveCacheResult<Value>> {
    private final Key key;
    private final ActiveCacheLoader<Key, Value> loader;
    private final Object syncObject;
    private final Map<Key, ActiveCacheResult<Value>> valueMap;
    private final Map<Key, Future<ActiveCacheResult<Value>>> loadingMap;

    public ActiveCacheCallable(Object syncObject, Map<Key, ActiveCacheResult<Value>> valueMap, Map<Key, Future<ActiveCacheResult<Value>>> loadingMap, Key key, ActiveCacheLoader<Key, Value> loader) {
        this.syncObject = syncObject;
        this.valueMap = valueMap;
        this.loadingMap = loadingMap;
        this.key = key;
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActiveCacheResult<Value> call() throws Exception {
        ActiveCacheResult<Object> result = null;
        try {
            result = new ActiveCacheResult<Value>(this.loader.load(this.key), null);
        }
        catch (Exception throwable) {
            result = new ActiveCacheResult<Object>(null, throwable);
        }
        finally {
            Object object = this.syncObject;
            synchronized (object) {
                this.loadingMap.remove(this.key);
                if (result.getException() == null) {
                    this.valueMap.put(this.key, result);
                }
            }
        }
        return result;
    }
}

