/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.repository.importexport;

import com.google.common.annotations.VisibleForTesting;
import com.pentaho.repository.importexport.PDIImportUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.missing.MissingEntry;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.repository.pur.JobDelegate;
import org.pentaho.di.ui.job.entries.missing.MissingEntryDialog;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.ConverterException;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.node.NodeRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class StreamToJobNodeConverter
implements Converter {
    IUnifiedRepository unifiedRepository;
    private static final Log logger = LogFactory.getLog(StreamToJobNodeConverter.class);
    private static Class<?> PKG = MissingEntryDialog.class;

    public StreamToJobNodeConverter(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public InputStream convert(IRepositoryFileData data) {
        throw new UnsupportedOperationException();
    }

    public InputStream convert(Serializable fileId) {
        InputStream is;
        block6: {
            is = null;
            try {
                if (fileId == null) break block6;
                Repository repository = this.connectToRepository();
                RepositoryFile file = this.unifiedRepository.getFileById(fileId);
                if (file == null) break block6;
                try {
                    JobMeta jobMeta = repository.loadJob((ObjectId)new StringObjectId(fileId.toString()), null);
                    if (jobMeta != null) {
                        return new ByteArrayInputStream(this.filterPrivateDatabases(jobMeta).getXML().getBytes());
                    }
                }
                catch (KettleException e) {
                    logger.error((Object)e);
                    SimpleRepositoryFileData fileData = (SimpleRepositoryFileData)this.unifiedRepository.getDataForRead(fileId, SimpleRepositoryFileData.class);
                    if (fileData != null) {
                        logger.warn((Object)("Reading as legacy CE job " + file.getName() + "."));
                        return fileData.getInputStream();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return is;
    }

    @VisibleForTesting
    JobMeta filterPrivateDatabases(JobMeta jobMeta) {
        Set privateDatabases = jobMeta.getPrivateDatabases();
        if (privateDatabases != null) {
            Iterator it = jobMeta.getDatabases().iterator();
            while (it.hasNext()) {
                DatabaseMeta databaseMeta = (DatabaseMeta)it.next();
                String databaseName = databaseMeta.getName();
                if (privateDatabases.contains(databaseName) || jobMeta.isDatabaseConnectionUsed(databaseMeta)) continue;
                it.remove();
            }
        }
        return jobMeta;
    }

    Repository connectToRepository() throws KettleException {
        return PDIImportUtil.connectToRepository(null);
    }

    public IRepositoryFileData convert(InputStream inputStream, String charset, String mimeType) {
        try {
            long size = inputStream.available();
            JobMeta jobMeta = new JobMeta();
            Repository repository = this.connectToRepository();
            Document doc = PDIImportUtil.loadXMLFrom(inputStream);
            if (doc != null) {
                jobMeta.loadXML((Node)doc.getDocumentElement(), repository, null);
                if (jobMeta.hasMissingPlugins()) {
                    KettleMissingPluginsException missingPluginsException = new KettleMissingPluginsException(this.getErrorMessage(jobMeta.getMissingEntries()));
                    throw new ConverterException((Throwable)missingPluginsException);
                }
                JobDelegate delegate = new JobDelegate(repository, this.unifiedRepository);
                delegate.saveSharedObjects((RepositoryElementInterface)jobMeta, null);
                return new NodeRepositoryFileData(delegate.elementToDataNode((RepositoryElementInterface)jobMeta), size);
            }
            return null;
        }
        catch (IOException | KettleException e) {
            return null;
        }
    }

    private String getErrorMessage(List<MissingEntry> missingEntries) {
        StringBuilder entries = new StringBuilder();
        for (MissingEntry entry : missingEntries) {
            entries.append("- " + entry.getName() + " - " + entry.getMissingPluginId() + "\n");
            if (missingEntries.indexOf(entry) != missingEntries.size() - 1) continue;
            entries.append('\n');
        }
        return BaseMessages.getString(PKG, (String)"MissingEntryDialog.MissingJobEntries", (String[])new String[]{entries.toString()});
    }

    public void saveSharedObjects(Repository repo, RepositoryElementInterface element) throws KettleException {
        JobMeta jobMeta = (JobMeta)element;
        List<String> databaseNames = Arrays.asList(repo.getDatabaseNames(true));
        int dbIndex = 0;
        int indexToReplace = 0;
        boolean updateMeta = Boolean.FALSE;
        for (DatabaseMeta databaseMeta : jobMeta.getDatabases()) {
            if (!databaseNames.contains(databaseMeta.getName())) {
                if (databaseMeta.getObjectId() == null || !StringUtils.isEmpty((String)databaseMeta.getHostname())) {
                    repo.save((RepositoryElementInterface)databaseMeta, null, null);
                }
            } else if (databaseMeta.getObjectId() == null) {
                indexToReplace = dbIndex;
                updateMeta = Boolean.TRUE;
            }
            ++dbIndex;
        }
        if (updateMeta) {
            DatabaseMeta dbMetaToReplace = jobMeta.getDatabase(indexToReplace);
            dbMetaToReplace.setObjectId(repo.getDatabaseID(dbMetaToReplace.getName()));
            jobMeta.removeDatabase(indexToReplace);
            jobMeta.addDatabase(dbMetaToReplace);
        }
        for (SlaveServer slaveServer : jobMeta.getSlaveServers()) {
            if (slaveServer.getObjectId() != null) continue;
            repo.save((RepositoryElementInterface)slaveServer, null, null);
        }
    }
}

