/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;

@ExtensionPoint(id="RepositoryImporterPatchTransStep", description="Patch the step in a transformation during repository import", extensionPointId="RepositoryImporterPatchTransStep")
public class RepositoryImporterExtension
implements ExtensionPointInterface {
    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        MetaInjectMeta metaInjectMeta;
        Object[] metaInjectObjectArray = (Object[])object;
        String transDirOverride = (String)metaInjectObjectArray[0];
        RepositoryDirectoryInterface baseDirectory = (RepositoryDirectoryInterface)metaInjectObjectArray[1];
        StepMeta stepMeta = (StepMeta)metaInjectObjectArray[2];
        boolean needToCheckPathForVariables = (Boolean)metaInjectObjectArray[3];
        if (stepMeta.isEtlMetaInject() && (metaInjectMeta = (MetaInjectMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME) {
            if (transDirOverride != null) {
                metaInjectMeta.setDirectoryPath(transDirOverride);
            } else {
                String mappingMetaPath = this.resolvePath(baseDirectory.getPath(), metaInjectMeta.getDirectoryPath(), needToCheckPathForVariables);
                metaInjectMeta.setDirectoryPath(mappingMetaPath);
            }
        }
    }

    String resolvePath(String rootPath, String entryPath, boolean check) {
        boolean needToCheckPathForVariables = check;
        String extraPath = Const.NVL((String)entryPath, (String)"/");
        if (needToCheckPathForVariables && RepositoryImporterExtension.containsVariables(entryPath)) {
            return extraPath;
        }
        String newPath = Const.NVL((String)rootPath, (String)"/");
        if (newPath.endsWith("/") && extraPath.startsWith("/")) {
            newPath = newPath.substring(0, newPath.length() - 1);
        } else if (!newPath.endsWith("/") && !extraPath.startsWith("/")) {
            newPath = newPath + "/";
        } else if (extraPath.equals("/")) {
            extraPath = "";
        }
        return newPath + extraPath;
    }

    private static boolean containsVariables(String entryPath) {
        ArrayList variablesList = new ArrayList();
        StringUtil.getUsedVariables((String)entryPath, variablesList, (boolean)true);
        return !variablesList.isEmpty();
    }
}

