/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.metastore.api.IMetaStore;

@ExtensionPoint(id="RepositoryExporterPatchTransStep", description="Patch the step in a transformation during repository export", extensionPointId="RepositoryExporterPatchTransStep")
public class RepositoryExporterExtension
implements ExtensionPointInterface {
    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        MetaInjectMeta metaInjectMeta;
        Object[] metaInjectObjectArray = (Object[])object;
        TransMeta transMeta = (TransMeta)metaInjectObjectArray[0];
        Class PKG = (Class)metaInjectObjectArray[1];
        KettleFileRepository fileRep = (KettleFileRepository)metaInjectObjectArray[2];
        StepMeta stepMeta = (StepMeta)metaInjectObjectArray[3];
        if (stepMeta.isEtlMetaInject() && (metaInjectMeta = (MetaInjectMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() == ObjectLocationSpecificationMethod.FILENAME) {
            try {
                TransMeta meta = MetaInjectMeta.loadTransformationMeta(metaInjectMeta, (Repository)fileRep, (IMetaStore)fileRep.metaStore, (VariableSpace)transMeta);
                FileObject fileObject = KettleVFS.getFileObject((String)meta.getFilename());
                metaInjectMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                metaInjectMeta.setFileName(null);
                metaInjectMeta.setTransName(meta.getName());
                metaInjectMeta.setDirectoryPath(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
            }
            catch (Exception e) {
                log.logError(BaseMessages.getString((Class)PKG, (String)"Repository.Exporter.Log.UnableToLoadTransInMDI", (String[])new String[]{metaInjectMeta.getName()}), (Throwable)e);
            }
        }
    }

    private String calcRepositoryDirectory(KettleFileRepository fileRep, FileObject fileObject) throws FileSystemException {
        String baseDirectory;
        String path = fileObject.getParent().getName().getPath();
        if (path.startsWith(baseDirectory = fileRep.getRepositoryMeta().getBaseDirectory())) {
            return path.substring(baseDirectory.length());
        }
        return path;
    }
}

