/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.injection.bean.BeanInjectionInfo;
import org.pentaho.di.core.injection.bean.BeanInjector;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransStoppedListener;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInjectData;
import org.pentaho.di.trans.steps.metainject.MetaInjectMeta;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;

public class MetaInject
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MetaInject.class;
    private static final Lock repoSaveLock = new ReentrantLock();
    private MetaInjectMeta meta;
    private MetaInjectData data;

    public MetaInject(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        String targetFile;
        this.meta = (MetaInjectMeta)smi;
        this.data = (MetaInjectData)sdi;
        this.data.rowMap = new HashMap<String, List<RowMetaAndData>>();
        for (String prevStepName : this.getTransMeta().getPrevStepNames(this.getStepMeta())) {
            if (this.data.streaming && prevStepName.equalsIgnoreCase(this.data.streamingSourceStepname)) continue;
            ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
            RowSet rowSet = this.findInputRowSet(prevStepName);
            Object[] row = this.getRowFrom(rowSet);
            while (row != null) {
                RowMetaAndData rd = new RowMetaAndData();
                rd.setRowMeta(rowSet.getRowMeta());
                rd.setData(row);
                list.add(rd);
                row = this.getRowFrom(rowSet);
            }
            if (list.isEmpty()) continue;
            this.data.rowMap.put(prevStepName, list);
        }
        List steps = this.data.transMeta.getSteps();
        for (Map.Entry<String, StepMetaInterface> en : this.data.stepInjectionMetasMap.entrySet()) {
            this.newInjection(en.getKey(), en.getValue());
        }
        for (Map.Entry<String, StepMetaInterface> en : this.data.stepInjectionMetasMap.entrySet()) {
            this.newInjectionConstants(en.getKey(), en.getValue());
        }
        for (Map.Entry<String, StepMetaInterface> en : this.data.stepInjectionMetasMap.entrySet()) {
            en.getValue().searchInfoAndTargetSteps(steps);
        }
        for (String targetStepName : this.data.stepInjectionMap.keySet()) {
            if (this.data.stepInjectionMetasMap.containsKey(targetStepName)) continue;
            this.oldInjection(targetStepName);
            StepMeta targetStep = StepMeta.findStep((List)steps, (String)targetStepName);
            if (targetStep == null) continue;
            targetStep.getStepMetaInterface().searchInfoAndTargetSteps(steps);
        }
        if (!this.meta.isNoExecution()) {
            final Trans injectTrans = this.createInjectTrans();
            injectTrans.setParentTrans(this.getTrans());
            injectTrans.setMetaStore(this.getMetaStore());
            if (this.getTrans().getParentJob() != null) {
                injectTrans.setParentJob(this.getTrans().getParentJob());
            }
            this.getTrans().addTransStoppedListener(new TransStoppedListener(){

                public void transStopped(Trans parentTrans) {
                    injectTrans.stopAll();
                }
            });
            injectTrans.prepareExecution(null);
            RowProducer rowProducer = null;
            if (this.data.streaming) {
                rowProducer = injectTrans.addRowProducer(this.data.streamingTargetStepname, 0);
            }
            this.getTrans().addActiveSubTransformation(this.getStepname(), injectTrans);
            if (!Utils.isEmpty((CharSequence)this.meta.getSourceStepName())) {
                StepInterface stepInterface = injectTrans.getStepInterface(this.meta.getSourceStepName(), 0);
                if (stepInterface == null) {
                    throw new KettleException("Unable to find step '" + this.meta.getSourceStepName() + "' to read from.");
                }
                stepInterface.addRowListener((RowListener)new RowAdapter(){

                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        MetaInject.this.putRow(rowMeta, row);
                    }
                });
            }
            injectTrans.startThreads();
            if (this.data.streaming) {
                RowSet rowSet = this.findInputRowSet(this.data.streamingSourceStepname);
                if (rowSet == null) {
                    throw new KettleException("Unable to find step '" + this.data.streamingSourceStepname + "' to stream data from");
                }
                Object[] row = this.getRowFrom(rowSet);
                while (row != null && !this.isStopped()) {
                    rowProducer.putRow(rowSet.getRowMeta(), row);
                    row = this.getRowFrom(rowSet);
                }
                rowProducer.finished();
            }
            while (!(injectTrans.isFinished() || injectTrans.isStopped() || this.isStopped())) {
                this.copyResult(injectTrans);
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
            this.copyResult(injectTrans);
            this.waitUntilFinished(injectTrans);
        }
        if (this.log.isDetailed()) {
            this.logDetailed("XML of transformation after injection: " + this.data.transMeta.getXML());
        }
        if (!Utils.isEmpty((CharSequence)(targetFile = this.environmentSubstitute(this.meta.getTargetFile())))) {
            this.writeInjectedKtr(targetFile);
        }
        this.setOutputDone();
        return false;
    }

    void waitUntilFinished(Trans injectTrans) {
        injectTrans.waitUntilFinished();
    }

    Trans createInjectTrans() {
        return new Trans(this.data.transMeta, (LoggingObjectInterface)this);
    }

    private boolean shouldWriteToFilesystem() {
        boolean forceWriteInFilesystem = ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)this.getVariable("KETTLE_COMPATIBILITY_MDI_INJECTED_FILE_ALWAYS_IN_FILESYSTEM"), (String)"N"));
        return this.getRepository() == null || forceWriteInFilesystem;
    }

    public Repository getRepository() {
        Repository repository = super.getRepository();
        return repository != null ? repository : this.getTransMeta().getRepository();
    }

    @VisibleForTesting
    void writeInjectedKtr(String targetFilPath) throws KettleException {
        if (this.shouldWriteToFilesystem()) {
            this.writeInjectedKtrToFs(targetFilPath);
        } else {
            this.writeInjectedKtrToRepo(targetFilPath);
        }
    }

    @VisibleForTesting
    void writeInjectedKtrToFs(String targetFilePath) throws KettleException {
        OutputStream os = null;
        try {
            TransMeta generatedTransMeta = (TransMeta)this.data.transMeta.realClone(false);
            File injectedKtrFile = new File(targetFilePath);
            if (injectedKtrFile == null) {
                throw new IOException();
            }
            String transName = injectedKtrFile.getName().replace(".ktr", "");
            generatedTransMeta.setName(transName);
            os = KettleVFS.getOutputStream((String)targetFilePath, (boolean)false);
            os.write(XMLHandler.getXMLHeader().getBytes("UTF-8"));
            os.write(generatedTransMeta.getXML().getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new KettleException("Unable to write target file (ktr after injection) to file '" + targetFilePath + "'", (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void writeInjectedKtrToRepo(String targetFilePath) throws KettleException {
        try {
            repoSaveLock.lock();
            TransMeta generatedTrans = (TransMeta)this.data.transMeta.realClone(false);
            ArrayList<String> targetPath = new ArrayList<String>(Arrays.asList(Const.splitPath((String)targetFilePath, (String)"/")));
            String fileName = ((String)targetPath.get(targetPath.size() - 1)).replace(".ktr", "");
            generatedTrans.setName(fileName);
            targetPath.remove(targetPath.size() - 1);
            if (targetPath.size() > 0) {
                String dirPath = String.join((CharSequence)"/", targetPath);
                RepositoryDirectoryInterface directory = this.getRepository().findDirectory(dirPath);
                if (directory == null) {
                    directory = this.getRepository().createRepositoryDirectory((RepositoryDirectoryInterface)new RepositoryDirectory(null, "/"), dirPath);
                }
                generatedTrans.setRepositoryDirectory(directory);
            } else {
                if (this.log.isDebug()) {
                    this.log.logDebug("The target injection ktr file path provided by the user is not a valid fully qualified repository path - will store the generated ktr in the same directory as the template ktr: ", new Object[]{this.data.transMeta.getRepositoryDirectory()});
                }
                generatedTrans.setRepositoryDirectory(this.data.transMeta.getRepositoryDirectory());
            }
            generatedTrans.setObjectId(this.getRepository().getTransformationID(fileName, generatedTrans.getRepositoryDirectory()));
            this.getRepository().save((RepositoryElementInterface)generatedTrans, null, null, true);
        }
        finally {
            repoSaveLock.unlock();
        }
    }

    private void newInjection(String targetStep, StepMetaInterface targetStepMeta) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Handing step '" + targetStep + "' injection!");
        }
        BeanInjectionInfo injectionInfo = new BeanInjectionInfo(targetStepMeta.getClass());
        BeanInjector injector = new BeanInjector(injectionInfo);
        Map<TargetStepAttribute, SourceStepField> targetMap = this.meta.getTargetSourceMapping();
        boolean wasInjection = false;
        for (TargetStepAttribute target : targetMap.keySet()) {
            List<RowMetaAndData> rows;
            SourceStepField source = targetMap.get(target);
            if (!target.getStepname().equalsIgnoreCase(targetStep) || source.getStepname() == null || (rows = this.data.rowMap.get(source.getStepname())) == null || rows.isEmpty()) continue;
            if (injector.hasProperty((Object)targetStepMeta, target.getAttributeKey())) {
                boolean skip = false;
                for (RowMetaAndData r : rows) {
                    if (r.getRowMeta().indexOfValue(source.getField()) >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"MetaInject.SourceFieldIsNotDefined.Message", (String[])new String[]{source.getField(), this.getTransMeta().getName()}));
                    skip = true;
                }
                if (skip) continue;
                injector.setProperty((Object)targetStepMeta, target.getAttributeKey(), rows, source.getField());
                wasInjection = true;
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetKeyIsNotDefined.Message", (String[])new String[]{target.getAttributeKey(), this.getTransMeta().getName()}));
        }
        if (wasInjection) {
            injector.runPostInjectionProcessing((Object)targetStepMeta);
        }
    }

    private void newInjectionConstants(String targetStep, StepMetaInterface targetStepMeta) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Handing step '" + targetStep + "' constants injection!");
        }
        BeanInjectionInfo injectionInfo = new BeanInjectionInfo(targetStepMeta.getClass());
        BeanInjector injector = new BeanInjector(injectionInfo);
        boolean wasInjection = false;
        for (Map.Entry<TargetStepAttribute, SourceStepField> entry : this.meta.getTargetSourceMapping().entrySet()) {
            TargetStepAttribute target = entry.getKey();
            SourceStepField source = entry.getValue();
            if (!target.getStepname().equalsIgnoreCase(targetStep) || source.getStepname() != null) continue;
            if (injector.hasProperty((Object)targetStepMeta, target.getAttributeKey())) {
                injector.setProperty((Object)targetStepMeta, target.getAttributeKey(), null, source.getField());
                wasInjection = true;
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetKeyIsNotDefined.Message", (String[])new String[]{target.getAttributeKey(), this.getTransMeta().getName()}));
        }
        if (wasInjection) {
            injector.runPostInjectionProcessing((Object)targetStepMeta);
        }
    }

    private void oldInjection(String targetStep) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Handing step '" + targetStep + "' injection!");
        }
        StepMetaInjectionInterface injectionInterface = this.data.stepInjectionMap.get(targetStep);
        List metadataEntries = injectionInterface.getStepInjectionMetadataEntries();
        ArrayList<StepInjectionMetaEntry> inject = new ArrayList<StepInjectionMetaEntry>();
        Map<TargetStepAttribute, SourceStepField> targetMap = this.meta.getTargetSourceMapping();
        for (TargetStepAttribute target : targetMap.keySet()) {
            SourceStepField source = targetMap.get(target);
            if (!target.getStepname().equalsIgnoreCase(targetStep)) continue;
            List<RowMetaAndData> rows = this.data.rowMap.get(source.getStepname());
            if (rows != null && rows.size() > 0) {
                StepInjectionMetaEntry entry = this.findMetaEntry(metadataEntries, target.getAttributeKey());
                if (entry != null) {
                    StepInjectionMetaEntry rootEntry;
                    if (!target.isDetail()) {
                        this.setEntryValueIfFieldExists(entry, rows.get(0), source);
                        inject.add(entry);
                        continue;
                    }
                    StepInjectionMetaEntry metaEntries = this.findMetaEntry(inject, entry.getKey());
                    if (metaEntries == null) {
                        rootEntry = this.findDetailRootEntry(metadataEntries, entry);
                        metaEntries = rootEntry.clone();
                        metaEntries.setDetails(new ArrayList());
                        inject.add(metaEntries);
                        StepInjectionMetaEntry metaEntry = (StepInjectionMetaEntry)rootEntry.getDetails().get(0);
                        for (int i = 0; i < rows.size(); ++i) {
                            StepInjectionMetaEntry metaCopy = metaEntry.clone();
                            metaEntries.getDetails().add(metaCopy);
                            metaCopy.setDetails(new ArrayList());
                            for (StepInjectionMetaEntry me : metaEntry.getDetails()) {
                                StepInjectionMetaEntry meCopy = me.clone();
                                metaCopy.getDetails().add(meCopy);
                            }
                        }
                    } else {
                        metaEntries = rootEntry = this.findDetailRootEntry(inject, metaEntries);
                    }
                    for (int i = 0; i < rows.size(); ++i) {
                        RowMetaAndData row = rows.get(i);
                        try {
                            List rowEntries = ((StepInjectionMetaEntry)metaEntries.getDetails().get(i)).getDetails();
                            for (StepInjectionMetaEntry rowEntry : rowEntries) {
                                SourceStepField detailSource = this.findDetailSource(targetMap, targetStep, rowEntry.getKey());
                                if (detailSource != null) {
                                    this.setEntryValueIfFieldExists(rowEntry, row, detailSource);
                                    continue;
                                }
                                if (!this.log.isDetailed()) continue;
                                this.logDetailed("No detail source found for key: " + rowEntry.getKey() + " and target step: " + targetStep);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            throw new KettleException("Unexpected error occurred while injecting metadata", (Throwable)e);
                        }
                    }
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed("injected entry: " + entry);
                    continue;
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed("entry not found: " + target.getAttributeKey());
                continue;
            }
            if (!this.log.isDetailed()) continue;
            this.logDetailed("No rows found for source step: " + source.getStepname());
        }
        injectionInterface.injectStepMetadataEntries(inject);
    }

    private void copyResult(Trans trans) {
        Result result = trans.getResult();
        this.setLinesInput(result.getNrLinesInput());
        this.setLinesOutput(result.getNrLinesOutput());
        this.setLinesRead(result.getNrLinesRead());
        this.setLinesWritten(result.getNrLinesWritten());
        this.setLinesUpdated(result.getNrLinesUpdated());
        this.setLinesRejected(result.getNrLinesRejected());
        this.setErrors(result.getNrErrors());
    }

    private StepInjectionMetaEntry findDetailRootEntry(List<StepInjectionMetaEntry> metadataEntries, StepInjectionMetaEntry entry) {
        for (StepInjectionMetaEntry rowsEntry : metadataEntries) {
            for (StepInjectionMetaEntry rowEntry : rowsEntry.getDetails()) {
                for (StepInjectionMetaEntry detailEntry : rowEntry.getDetails()) {
                    if (!detailEntry.equals(entry)) continue;
                    return rowsEntry;
                }
            }
        }
        return null;
    }

    private SourceStepField findDetailSource(Map<TargetStepAttribute, SourceStepField> targetMap, String targetStep, String key) {
        return targetMap.get(new TargetStepAttribute(targetStep, key, true));
    }

    private StepInjectionMetaEntry findMetaEntry(List<StepInjectionMetaEntry> metadataEntries, String attributeKey) {
        for (StepInjectionMetaEntry entry : metadataEntries) {
            if (entry.getKey().equals(attributeKey)) {
                return entry;
            }
            if ((entry = this.findMetaEntry(entry.getDetails(), attributeKey)) == null) continue;
            return entry;
        }
        return null;
    }

    void setEntryValueIfFieldExists(StepInjectionMetaEntry entry, RowMetaAndData row, SourceStepField source) throws KettleValueException {
        RowMetaInterface rowMeta = row.getRowMeta();
        if (rowMeta.indexOfValue(source.getField()) < 0) {
            return;
        }
        MetaInject.setEntryValue(entry, row, source);
    }

    static void setEntryValue(StepInjectionMetaEntry entry, RowMetaAndData row, SourceStepField source) throws KettleValueException {
        Object value = null;
        switch (entry.getValueType()) {
            case 2: {
                value = row.getString(source.getField(), null);
                break;
            }
            case 4: {
                value = row.getBoolean(source.getField(), false);
                break;
            }
            case 5: {
                value = row.getInteger(source.getField(), 0L);
                break;
            }
            case 1: {
                value = row.getNumber(source.getField(), 0.0);
                break;
            }
            case 3: {
                value = row.getDate(source.getField(), null);
                break;
            }
            case 6: {
                value = row.getBigNumber(source.getField(), null);
                break;
            }
        }
        entry.setValue(value);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MetaInjectMeta)smi;
        this.data = (MetaInjectData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.actualizeMetaInjectMapping();
                this.data.transMeta = this.loadTransformationMeta();
                this.data.transMeta.copyVariablesFrom((VariableSpace)this);
                this.data.transMeta.mergeParametersWith((NamedParams)this.getTrans(), true);
                this.checkSoureStepsAvailability();
                this.checkTargetStepsAvailability();
                this.data.stepInjectionMetasMap = new HashMap<String, StepMetaInterface>();
                for (StepMeta stepMeta : this.data.transMeta.getUsedSteps()) {
                    StepMetaInterface meta = stepMeta.getStepMetaInterface();
                    if (!BeanInjectionInfo.isInjectionSupported(meta.getClass())) continue;
                    this.data.stepInjectionMetasMap.put(stepMeta.getName(), meta);
                }
                this.data.stepInjectionMap = new HashMap<String, StepMetaInjectionInterface>();
                for (StepMeta stepMeta : this.data.transMeta.getUsedSteps()) {
                    StepMetaInjectionInterface injectionInterface = stepMeta.getStepMetaInterface().getStepMetaInjectionInterface();
                    if (injectionInterface == null) continue;
                    this.data.stepInjectionMap.put(stepMeta.getName(), injectionInterface);
                }
                if (this.meta.getStreamSourceStep() != null && !Utils.isEmpty((CharSequence)this.meta.getStreamTargetStepname())) {
                    this.data.streaming = true;
                    this.data.streamingSourceStepname = this.meta.getStreamSourceStep().getName();
                    this.data.streamingTargetStepname = this.meta.getStreamTargetStepname();
                }
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MetaInject.BadEncoding.Message", (String[])new String[0]), e);
                return false;
            }
        }
        return false;
    }

    private void checkTargetStepsAvailability() {
        Set<String> existedStepNames = MetaInject.convertToUpperCaseSet(this.data.transMeta.getStepNames());
        Map<TargetStepAttribute, SourceStepField> targetMap = this.meta.getTargetSourceMapping();
        Set<TargetStepAttribute> unavailableTargetSteps = MetaInject.getUnavailableTargetSteps(targetMap, this.data.transMeta);
        HashSet<String> alreadyMarkedSteps = new HashSet<String>();
        for (TargetStepAttribute currentTarget : unavailableTargetSteps) {
            if (alreadyMarkedSteps.contains(currentTarget.getStepname())) continue;
            alreadyMarkedSteps.add(currentTarget.getStepname());
            if (existedStepNames.contains(currentTarget.getStepname().toUpperCase())) {
                this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetStepIsNotUsed.Message", (String[])new String[]{currentTarget.getStepname(), this.data.transMeta.getName()}));
                continue;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.TargetStepIsNotDefined.Message", (String[])new String[]{currentTarget.getStepname(), this.data.transMeta.getName()}));
        }
    }

    public static void removeUnavailableStepsFromMapping(Map<TargetStepAttribute, SourceStepField> targetMap, Set<SourceStepField> unavailableSourceSteps, Set<TargetStepAttribute> unavailableTargetSteps) {
        Iterator<Map.Entry<TargetStepAttribute, SourceStepField>> targetMapIterator = targetMap.entrySet().iterator();
        while (targetMapIterator.hasNext()) {
            Map.Entry<TargetStepAttribute, SourceStepField> entry = targetMapIterator.next();
            SourceStepField currentSourceStepField = entry.getValue();
            TargetStepAttribute currentTargetStepAttribute = entry.getKey();
            if (!unavailableSourceSteps.contains(currentSourceStepField) && !unavailableTargetSteps.contains(currentTargetStepAttribute)) continue;
            targetMapIterator.remove();
        }
    }

    public static Set<TargetStepAttribute> getUnavailableTargetSteps(Map<TargetStepAttribute, SourceStepField> targetMap, TransMeta injectedTransMeta) {
        Set<String> usedStepNames = MetaInject.getUsedStepsForReferencendTransformation(injectedTransMeta);
        HashSet<TargetStepAttribute> unavailableTargetSteps = new HashSet<TargetStepAttribute>();
        for (TargetStepAttribute currentTarget : targetMap.keySet()) {
            if (usedStepNames.contains(currentTarget.getStepname().toUpperCase())) continue;
            unavailableTargetSteps.add(currentTarget);
        }
        return Collections.unmodifiableSet(unavailableTargetSteps);
    }

    public static Set<TargetStepAttribute> getUnavailableTargetKeys(Map<TargetStepAttribute, SourceStepField> targetMap, TransMeta injectedTransMeta, Set<TargetStepAttribute> unavailableTargetSteps) {
        HashSet<TargetStepAttribute> missingKeys = new HashSet<TargetStepAttribute>();
        Map<String, BeanInjectionInfo> beanInfos = MetaInject.getUsedStepBeanInfos(injectedTransMeta);
        for (TargetStepAttribute key : targetMap.keySet()) {
            BeanInjectionInfo info;
            if (unavailableTargetSteps.contains(key) || (info = beanInfos.get(key.getStepname().toUpperCase())) == null || info.getProperties().containsKey(key.getAttributeKey())) continue;
            missingKeys.add(key);
        }
        return missingKeys;
    }

    private static Map<String, BeanInjectionInfo> getUsedStepBeanInfos(TransMeta transMeta) {
        HashMap<String, BeanInjectionInfo> res = new HashMap<String, BeanInjectionInfo>();
        for (StepMeta step : transMeta.getUsedSteps()) {
            Class<?> stepMetaClass = step.getStepMetaInterface().getClass();
            if (!BeanInjectionInfo.isInjectionSupported(stepMetaClass)) continue;
            res.put(step.getName().toUpperCase(), new BeanInjectionInfo(stepMetaClass));
        }
        return res;
    }

    private static Set<String> getUsedStepsForReferencendTransformation(TransMeta transMeta) {
        HashSet<String> usedStepNames = new HashSet<String>();
        for (StepMeta currentStep : transMeta.getUsedSteps()) {
            usedStepNames.add(currentStep.getName().toUpperCase());
        }
        return usedStepNames;
    }

    public static Set<SourceStepField> getUnavailableSourceSteps(Map<TargetStepAttribute, SourceStepField> targetMap, TransMeta sourceTransMeta, StepMeta stepMeta) {
        String[] stepNamesArray = sourceTransMeta.getPrevStepNames(stepMeta);
        Set<String> existedStepNames = MetaInject.convertToUpperCaseSet(stepNamesArray);
        HashSet<SourceStepField> unavailableSourceSteps = new HashSet<SourceStepField>();
        for (SourceStepField currentSource : targetMap.values()) {
            if (currentSource.getStepname() == null || existedStepNames.contains(currentSource.getStepname().toUpperCase())) continue;
            unavailableSourceSteps.add(currentSource);
        }
        return Collections.unmodifiableSet(unavailableSourceSteps);
    }

    private void checkSoureStepsAvailability() {
        Map<TargetStepAttribute, SourceStepField> targetMap = this.meta.getTargetSourceMapping();
        Set<SourceStepField> unavailableSourceSteps = MetaInject.getUnavailableSourceSteps(targetMap, this.getTransMeta(), this.getStepMeta());
        HashSet<String> alreadyMarkedSteps = new HashSet<String>();
        for (SourceStepField currentSource : unavailableSourceSteps) {
            if (alreadyMarkedSteps.contains(currentSource.getStepname())) continue;
            alreadyMarkedSteps.add(currentSource.getStepname());
            this.logError(BaseMessages.getString(PKG, (String)"MetaInject.SourceStepIsNotAvailable.Message", (String[])new String[]{currentSource.getStepname(), this.getTransMeta().getName()}));
        }
    }

    static Set<String> convertToUpperCaseSet(String[] array) {
        if (array == null) {
            return Collections.emptySet();
        }
        HashSet<String> strings = new HashSet<String>();
        for (String currentString : array) {
            strings.add(currentString.toUpperCase());
        }
        return strings;
    }

    TransMeta loadTransformationMeta() throws KettleException {
        return MetaInjectMeta.loadTransformationMeta(this.meta, this.getTrans().getRepository(), this.getTrans().getMetaStore(), (VariableSpace)this);
    }
}

