/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public final class MfCmdSetPaletteEntries
extends MfCmd {
    private static final int BASE_RECORD_SIZE = 3;
    private static final int POS_H_PALETTE = 0;
    private static final int POS_CSTART = 1;
    private static final int POS_CENTRIES = 2;
    private int hPalette;
    private Color[] colors = COLOR;
    private int startPos;
    private static final Color[] COLOR = new Color[0];

    @Override
    public void replay(WmfFile file) {
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetPaletteEntries();
    }

    public Color[] getEntries() {
        return (Color[])this.colors.clone();
    }

    public void setEntries(Color[] colors) {
        this.colors = (Color[])colors.clone();
    }

    @Override
    public void setRecord(MfRecord record) {
        int hPalette = record.getParam(0);
        int cStart = record.getParam(1);
        int cEntries = record.getParam(2);
        Color[] colors = new Color[cEntries];
        for (int i = 0; i < cEntries; ++i) {
            int colorRef = record.getLongParam(2 * i + 3);
            GDIColor color = new GDIColor(colorRef);
            colors[i] = color;
        }
        this.setStartPos(cStart);
        this.setEntries(colors);
        this.setHPalette(hPalette);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        Color[] cEntries = this.getEntries();
        if (cEntries == null) {
            throw new NullPointerException("No CEntries set");
        }
        MfRecord record = new MfRecord(2 * cEntries.length + 3);
        record.setParam(0, this.getHPalette());
        record.setParam(1, this.getStartPos());
        record.setParam(2, cEntries.length);
        for (int i = 0; i < cEntries.length; ++i) {
            record.setLongParam(2 * i + 3, GDIColor.translateColor(cEntries[i]));
        }
        return record;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int startPos) {
        this.startPos = startPos;
    }

    @Override
    public int getFunction() {
        return 55;
    }

    public int getHPalette() {
        return this.hPalette;
    }

    public void setHPalette(int hPalette) {
        this.hPalette = hPalette;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("[SET_PALETTE_ENTRIES] entriesCount=");
        if (this.getEntries() == null) {
            b.append(0);
        } else {
            b.append(this.getEntries().length);
        }
        b.append(" hpalette=");
        b.append(this.hPalette);
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

