/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.format;

import java.lang.reflect.Constructor;
import mondrian.resource.MondrianResource;
import mondrian.rolap.format.DefaultFormatter;
import mondrian.rolap.format.DefaultRolapMemberFormatter;
import mondrian.rolap.format.FormatterCreateContext;
import mondrian.rolap.format.PropertyFormatterAdapter;
import mondrian.spi.CellFormatter;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import mondrian.spi.impl.Scripts;

public class FormatterFactory {
    private static final DefaultFormatter DEFAULT_FORMATTER = new DefaultFormatter();
    private static final PropertyFormatter DEFAULT_PROPERTY_FORMATTER = new PropertyFormatterAdapter(DEFAULT_FORMATTER);
    private static final MemberFormatter DEFAULT_MEMBER_FORMATTER = new DefaultRolapMemberFormatter(DEFAULT_FORMATTER);
    private static final FormatterFactory INSTANCE = new FormatterFactory();

    private FormatterFactory() {
    }

    public static FormatterFactory instance() {
        return INSTANCE;
    }

    public CellFormatter createCellFormatter(FormatterCreateContext context) {
        try {
            if (context.getFormatterClassName() != null) {
                return (CellFormatter)FormatterFactory.createFormatter(context.getFormatterClassName());
            }
            if (context.getScriptText() != null) {
                return Scripts.cellFormatter(context.getScriptText(), context.getScriptLanguage());
            }
        }
        catch (Exception e) {
            throw MondrianResource.instance().CellFormatterLoadFailed.ex(context.getFormatterClassName(), context.getElementName(), e);
        }
        return null;
    }

    public MemberFormatter createRolapMemberFormatter(FormatterCreateContext context) {
        try {
            if (context.getFormatterClassName() != null) {
                return (MemberFormatter)FormatterFactory.createFormatter(context.getFormatterClassName());
            }
            if (context.getScriptText() != null) {
                return Scripts.memberFormatter(context.getScriptText(), context.getScriptLanguage());
            }
        }
        catch (Exception e) {
            throw MondrianResource.instance().MemberFormatterLoadFailed.ex(context.getFormatterClassName(), context.getElementName(), e);
        }
        return DEFAULT_MEMBER_FORMATTER;
    }

    public PropertyFormatter createPropertyFormatter(FormatterCreateContext context) {
        try {
            if (context.getFormatterClassName() != null) {
                return (PropertyFormatter)FormatterFactory.createFormatter(context.getFormatterClassName());
            }
            if (context.getScriptText() != null) {
                return Scripts.propertyFormatter(context.getScriptText(), context.getScriptLanguage());
            }
        }
        catch (Exception e) {
            throw MondrianResource.instance().PropertyFormatterLoadFailed.ex(context.getFormatterClassName(), context.getElementName(), e);
        }
        return DEFAULT_PROPERTY_FORMATTER;
    }

    private static <T> T createFormatter(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        return (T)constructor.newInstance(new Object[0]);
    }
}

