/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.sort.Sorter;
import mondrian.olap.fun.sort.TupleExpMemoComparator;

class HierarchicalTupleComparator
extends TupleExpMemoComparator {
    private final boolean desc;

    HierarchicalTupleComparator(Evaluator evaluator, Calc calc, int arity, boolean desc) {
        super(evaluator, calc, arity);
        this.desc = desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nonEqualCompare(List<Member> a1, List<Member> a2) {
        int c = 0;
        int savepoint = this.evaluator.savepoint();
        try {
            for (int i = 0; i < this.arity; ++i) {
                Member m2;
                Member m1 = a1.get(i);
                c = this.compareHierarchicallyButSiblingsByValue(m1, m2 = a2.get(i));
                if (c != 0) {
                    break;
                }
                assert (m1.equals(m2));
                this.evaluator.setContext(m1);
            }
        }
        finally {
            this.evaluator.restore(savepoint);
        }
        return c;
    }

    protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
        Member prev2;
        Member prev1;
        if (Util.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                return -1;
            }
            if (depth1 > depth2) {
                if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                return 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        int c = this.compareByValue(prev1, prev2);
        if (c == 0) {
            c = Sorter.compareSiblingMembers(prev1, prev2);
        }
        return this.desc ? -c : c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareByValue(Member m1, Member m2) {
        int savepoint = this.evaluator.savepoint();
        try {
            int c;
            this.evaluator.setContext(m1);
            Object v1 = this.calc.evaluate(this.evaluator);
            this.evaluator.setContext(m2);
            Object v2 = this.calc.evaluate(this.evaluator);
            int n = c = Sorter.compareValues(v1, v2);
            return n;
        }
        finally {
            this.evaluator.restore(savepoint);
        }
    }
}

