/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

class HeadTailFunDef
extends FunDefBase {
    static final Resolver TailResolver = new ReflectiveMultiResolver("Tail", "Tail(<Set>[, <Count>])", "Returns a subset from the end of a set.", new String[]{"fxx", "fxxn"}, HeadTailFunDef.class);
    static final Resolver HeadResolver = new ReflectiveMultiResolver("Head", "Head(<Set>[, < Numeric Expression >])", "Returns the first specified number of elements in a set.", new String[]{"fxx", "fxxn"}, HeadTailFunDef.class);
    private final boolean head;

    public HeadTailFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        this.head = dummyFunDef.getName().equals("Head");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ConstantCalc integerCalc;
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        IntegerCalc integerCalc2 = integerCalc = call.getArgCount() > 1 ? compiler.compileInteger(call.getArg(1)) : ConstantCalc.constantInteger(1);
        if (this.head) {
            return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc}){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public TupleList evaluateList(Evaluator evaluator) {
                    int savepoint = evaluator.savepoint();
                    try {
                        evaluator.setNonEmpty(false);
                        TupleList list = listCalc.evaluateList(evaluator);
                        int count = integerCalc.evaluateInteger(evaluator);
                        TupleList tupleList = HeadTailFunDef.head(count, list);
                        return tupleList;
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    evaluator.setNonEmpty(false);
                    TupleList list = listCalc.evaluateList(evaluator);
                    int count = integerCalc.evaluateInteger(evaluator);
                    TupleList tupleList = HeadTailFunDef.tail(count, list);
                    return tupleList;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
        };
    }

    static TupleList tail(int count, TupleList members) {
        assert (members != null);
        int memberCount = members.size();
        if (count >= memberCount) {
            return members;
        }
        if (count <= 0) {
            return TupleCollections.emptyList(members.getArity());
        }
        return members.subList(members.size() - count, members.size());
    }

    static TupleList head(int count, TupleList members) {
        assert (members != null);
        if (count <= 0) {
            return TupleCollections.emptyList(members.getArity());
        }
        return members.subList(0, Math.min(count, members.size()));
    }
}

