/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractEndToEndTupleList;
import mondrian.calc.impl.AbstractTupleList;
import mondrian.olap.Member;
import mondrian.olap.Util;

public class ListTupleList
extends AbstractEndToEndTupleList {
    private final List<Member> list;

    public ListTupleList(int arity, List<Member> list) {
        super(arity);
        this.list = list;
    }

    @Override
    protected List<Member> backingList() {
        return this.list;
    }

    @Override
    public Member get(int slice, int index) {
        return this.list.get(index * this.arity + slice);
    }

    @Override
    public List<Member> get(int index) {
        final int startIndex = index * this.arity;
        AbstractList<Member> list1 = new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return (Member)ListTupleList.this.list.get(startIndex + index);
            }

            @Override
            public int size() {
                return ListTupleList.this.arity;
            }
        };
        if (this.mutable) {
            return Util.flatList(list1);
        }
        return list1;
    }

    @Override
    public void add(int index, List<Member> element) {
        assert (this.mutable);
        this.list.addAll(index * this.arity, element);
    }

    @Override
    public void addTuple(Member ... members) {
        assert (this.mutable);
        this.list.addAll(Arrays.asList(members));
    }

    @Override
    public void clear() {
        assert (this.mutable);
        this.list.clear();
    }

    @Override
    public List<Member> remove(int index) {
        assert (this.mutable);
        int n = index * this.arity;
        for (int i = 0; i < this.arity; ++i) {
            this.list.remove(n);
        }
        return null;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        assert (this.mutable);
        this.list.subList(fromIndex * this.arity, toIndex * this.arity).clear();
    }

    @Override
    public int size() {
        return this.list.size() / this.arity;
    }

    @Override
    public List<Member> slice(final int column) {
        if (column < 0 || column >= this.arity) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return ListTupleList.this.get(column, index);
            }

            @Override
            public int size() {
                return ListTupleList.this.size();
            }
        };
    }

    @Override
    public TupleList cloneList(int capacity) {
        return new ListTupleList(this.arity, capacity < 0 ? new ArrayList<Member>(this.list) : new ArrayList(capacity * this.arity));
    }

    @Override
    public TupleIterator tupleIteratorInternal() {
        return new AbstractTupleList.AbstractTupleListIterator(this);
    }
}

