/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.jsoninput.getfields;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.json.JsonSampler;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class GetFieldsDialog
extends Dialog {
    private static final Class<?> PKG = GetFieldsDialog.class;
    private List<String> paths = new ArrayList<String>();
    protected Button ok;
    protected Button cancel;
    protected Button clearSelection;
    private PropsUI props = PropsUI.getInstance();
    private static final Image LOGO = GUIResource.getInstance().getImageLogoSmall();

    public GetFieldsDialog(Shell parent) {
        super(parent, 0);
    }

    public void open(String filename, List<String> paths, TableView wFields) {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        if (StringUtils.isBlank((String)filename)) {
            MessageBox mb = new MessageBox(parent, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"get-fields.plugin.app.unable-to-view.no-input.message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.unable-to-view.label", (String[])new String[0]));
            mb.open();
            return;
        }
        Shell shell = new Shell(parent, 3312);
        try {
            this.props.setLook((Control)shell);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            formLayout.marginHeight = 5;
            shell.setLayout((Layout)formLayout);
            shell.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.header.DialogTitle", (String[])new String[0]));
            shell.setImage(LOGO);
            shell.setSize(520, 700);
            Monitor primary = parent.getMonitor();
            Rectangle bounds = primary.getBounds();
            Rectangle rect = shell.getClientArea();
            int x = bounds.x + (bounds.width - rect.width) / 2;
            int y = bounds.y + (bounds.height - rect.height) / 2;
            shell.setLocation(x, y);
            StyledText labelSelectFields = new StyledText((Composite)shell, 0);
            this.props.setLook((Control)labelSelectFields);
            labelSelectFields.setLayoutData((Object)new FormDataBuilder().top(1, 0).result());
            String label = BaseMessages.getString(PKG, (String)"get-fields-plugin.app.header.title", (String[])new String[0]);
            labelSelectFields.setText(label);
            StyleRange style1 = new StyleRange();
            style1.start = 0;
            style1.length = label.length();
            style1.fontStyle = 1;
            labelSelectFields.setStyleRange(style1);
            Text search = new Text((Composite)shell, 896);
            this.props.setLook((Control)search);
            search.setLayoutData((Object)new FormDataBuilder().right(100, 0).width(200).result());
            search.setMessage(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.header.search-parsed-fields.placeholder", (String[])new String[0]));
            Tree tree = new Tree((Composite)shell, 2848);
            this.props.setLook((Control)tree);
            tree.setLayoutData((Object)new FormDataBuilder().top((Control)labelSelectFields, 4).left(0, 0).right(100, 0).bottom(100, -85).result());
            JsonSampler jsonSampler = new JsonSampler();
            jsonSampler.sample(filename, tree);
            this.clearSelection = new Button((Composite)shell, 8);
            this.clearSelection.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.clear-selection.label", (String[])new String[0]));
            this.props.setLook((Control)this.clearSelection);
            BaseStepDialog.positionBottomButtons((Composite)shell, (Button[])new Button[]{this.clearSelection}, (int)2, (Control)tree);
            Label separator = new Label((Composite)shell, 266);
            this.props.setLook((Control)separator);
            separator.setLayoutData((Object)new FormDataBuilder().top((Control)this.clearSelection, 4).fullWidth().result());
            this.ok = new Button((Composite)shell, 8);
            this.ok.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.ok.button", (String[])new String[0]));
            this.cancel = new Button((Composite)shell, 8);
            this.cancel.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.cancel.button", (String[])new String[0]));
            BaseStepDialog.positionBottomRightButtons((Composite)shell, (Button[])new Button[]{this.ok, this.cancel}, (int)2, (Control)separator);
            TreeItem item = tree.getItem(0);
            paths.forEach(path -> jsonSampler.selectByPath((String)path, item));
            this.setExpanded(item);
            tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 32) {
                        TreeItem item = (TreeItem)event.item;
                        boolean checked = item.getChecked();
                        item.setChecked(checked);
                        if (Objects.isNull(item.getData("Key"))) {
                            this.checkItems(item, checked);
                        }
                    }
                }

                private void checkItems(TreeItem item, boolean checked) {
                    TreeItem[] items = item.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        item.getItem(i).setChecked(checked);
                    }
                }
            });
            search.addModifyListener(modifyEvent -> {
                boolean isSearchInvalid = this.doSearch(item, search.getText(), Boolean.TRUE);
                if (isSearchInvalid) {
                    MessageBox mb = new MessageBox(shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.unable-to-find.label", (String[])new String[0]) + " \"" + search.getText() + "\"");
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            });
            Listener okListener = e -> this.ok(jsonSampler, tree, shell, wFields);
            this.ok.addListener(13, okListener);
            Listener cancelListener = e -> shell.dispose();
            this.cancel.addListener(13, cancelListener);
            Listener clearSelectionListener = e -> this.clearSelection(item);
            this.clearSelection.addListener(13, clearSelectionListener);
            shell.open();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
                break;
            }
        }
        catch (KettleFileException e2) {
            MessageBox mb = new MessageBox(shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"get-fields.plugin.app.unable-to-access.message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"get-fields-plugin.app.unable-to-access.label", (String[])new String[0]));
            mb.open();
        }
        catch (IOException e3) {
            MessageBox mb = new MessageBox(shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"get-fields.plugin.app.unable-to-view.invalid.message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"get-fields.plugin.app.unable-to-view.invalid.header", (String[])new String[0]));
            mb.open();
        }
    }

    private boolean doSearch(TreeItem item, String data, boolean isSearchInvalid) {
        if (StringUtils.isNotBlank((String)data)) {
            if (item.getText().contains(data)) {
                item.setBackground(GUIResource.getInstance().getColorLightBlue());
                item.setForeground(GUIResource.getInstance().getColorBlack());
                isSearchInvalid = Boolean.FALSE;
            } else {
                item.setForeground(GUIResource.getInstance().getColorGray());
                item.setBackground(GUIResource.getInstance().getColorWhite());
                if (isSearchInvalid) {
                    isSearchInvalid = Boolean.TRUE;
                }
            }
        } else {
            item.setBackground(GUIResource.getInstance().getColorWhite());
            item.setForeground(GUIResource.getInstance().getColorBlack());
            isSearchInvalid = Boolean.FALSE;
        }
        for (TreeItem child : item.getItems()) {
            isSearchInvalid = this.doSearch(child, data, isSearchInvalid);
        }
        return isSearchInvalid;
    }

    private void setExpanded(TreeItem item) {
        item.setExpanded(true);
        for (TreeItem child : item.getItems()) {
            this.setExpanded(child);
        }
    }

    private void clearSelection(TreeItem item) {
        item.setChecked(false);
        for (TreeItem child : item.getItems()) {
            this.clearSelection(child);
        }
    }

    private void ok(JsonSampler jsonSampler, Tree tree, Shell shell, TableView wFields) {
        this.paths.clear();
        this.paths.addAll(jsonSampler.getChecked(tree));
        wFields.table.setItemCount(this.paths.size());
        if (!this.paths.isEmpty()) {
            for (int i = 0; i < this.paths.size(); ++i) {
                String path = this.paths.get(i);
                String[] values = path.split(":");
                TableItem item = wFields.table.getItem(i);
                item.setText(1, values[0]);
                item.setText(2, values[1]);
                item.setText(3, values[2]);
            }
        }
        wFields.removeEmptyRows();
        wFields.setRowNums();
        wFields.optWidth(true);
        shell.dispose();
    }
}

