/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput.json.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pentaho.di.trans.steps.jsoninput.json.node.ArrayNode;
import org.pentaho.di.trans.steps.jsoninput.json.node.Node;

public class ObjectNode
extends Node {
    public static final String TYPE = "Object";
    private List<Node> children = new ArrayList<Node>();

    public ObjectNode(String key) {
        super(key);
    }

    public void addValue(Node value) {
        this.children.add(value);
    }

    @Override
    public List<Node> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public void dedupe() {
        for (Node node : this.children) {
            node.dedupe();
        }
    }

    public boolean containsKey(String key) {
        return this.children.stream().anyMatch(node -> node.getKey().equals(key));
    }

    public Node getByKey(String key) {
        return this.children.stream().filter(node -> node.getKey().equals(key)).findFirst().orElse(null);
    }

    public void combine(ObjectNode secondNode) {
        for (Node node : secondNode.getChildren()) {
            if (!this.containsKey(node.getKey())) {
                this.addValue(node);
            }
            if (node instanceof ObjectNode) {
                ObjectNode objectNode1 = (ObjectNode)this.getByKey(node.getKey());
                ObjectNode objectNode2 = (ObjectNode)node;
                objectNode1.combine(objectNode2);
            }
            if (!(node instanceof ArrayNode)) continue;
            ArrayNode arrayNode1 = (ArrayNode)this.getByKey(node.getKey());
            ArrayNode arrayNode2 = (ArrayNode)node;
            arrayNode1.combine(arrayNode2);
            arrayNode1.dedupe();
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        if (Objects.nonNull(this.getKey())) {
            output.append(this.getKey()).append(": {\n");
        } else {
            output.append("{\n");
        }
        for (Node node : this.children) {
            output.append(node.toString());
        }
        return output.append("},\n").toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

