/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.palo.JobEntryCubeCreate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.palo.JobEntryCubeCreate.PaloCubeCreate;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.palo.core.PaloNameComparator;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PaloCubeCreateDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = PaloCubeCreate.class;
    private Text textStepName;
    private Label labelStepName;
    private CCombo addConnectionLine;
    private Label labelCubeName;
    private Text textCubeName;
    private ColumnInfo[] colinf;
    private TableView tableViewFields;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private PaloCubeCreate jobEntry;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private ColumnInfo comboDropDown;
    private SelectionAdapter lsDef;
    private boolean changed;
    private JobMeta jobMeta;

    public PaloCubeCreateDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (PaloCubeCreate)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(jobEntryInt.getName());
        }
        this.jobMeta = jobMeta;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PaloCubeCreateDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PaloCubeCreateDialog.PaloCubeCreate", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"PaloCubeCreateDialog.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.labelStepName);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 18436);
        this.textStepName.setText(this.jobEntry.getName());
        this.props.setLook((Control)this.textStepName);
        this.textStepName.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaloCubeCreateDialog.this.doSelectConnection(false);
            }
        });
        this.props.setLook((Control)this.addConnectionLine);
        this.labelCubeName = new Label((Composite)this.shell, 131072);
        this.labelCubeName.setText(BaseMessages.getString(PKG, (String)"PaloCubeCreateDialog.CubeName", (String[])new String[0]));
        this.props.setLook((Control)this.labelCubeName);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelCubeName.setLayoutData((Object)fd);
        this.textCubeName = new Text((Composite)this.shell, 18436);
        this.textCubeName.addModifyListener(lsMod);
        this.props.setLook((Control)this.textCubeName);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.textCubeName.setLayoutData((Object)fd);
        this.colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 2, new String[0], false)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2048, this.colinf, 10, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 105);
        this.tableViewFields.setBounds(5, 250, 477, 105);
        this.tableViewFields.setReadonly(false);
        this.tableViewFields.table.removeAll();
        this.tableViewFields.optWidth(true);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.textCubeName, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.tableViewFields.table.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                PaloCubeCreateDialog.this.doBuildDimensionList();
            }
        });
        this.props.setLook((Control)this.tableViewFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOK, this.wCancel}, (int)margin, (Control)this.tableViewFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                PaloCubeCreateDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                PaloCubeCreateDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PaloCubeCreateDialog.this.ok();
            }
        };
        this.textStepName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PaloCubeCreateDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"PaloCellCreateDialog.ColumnDimension", (String[])new String[0]);
            }
        }
        return "";
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBuildDimensionList() {
        DatabaseMeta dbMeta;
        if (this.comboDropDown == null && this.addConnectionLine.getText() != null && (dbMeta = DatabaseMeta.findDatabase((List)this.jobMeta.getDatabases(), (String)this.addConnectionLine.getText())) != null) {
            PaloHelper helper = new PaloHelper(dbMeta, DefaultLogLevel.getLogLevel());
            try {
                helper.connect();
                List dimensionNames = helper.getDimensionsNames();
                List dimensions = helper.getDimensionsNames();
                Collections.sort(dimensions, new PaloNameComparator());
                this.comboDropDown = new ColumnInfo("Field", 2, dimensions.toArray(new String[dimensionNames.size()]), true);
                this.tableViewFields.setColumnInfo(0, this.comboDropDown);
            }
            catch (Exception ex) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.RetreiveCubesErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PaloCellOutputDialog.RetreiveCubesError", (String[])new String[0]), ex);
            }
            finally {
                helper.disconnect();
            }
        }
    }

    private void doSelectConnection(boolean clearCurrentData) {
        this.comboDropDown = null;
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.textStepName.setText(this.jobEntry.getName());
        }
        this.textStepName.selectAll();
        int index = this.addConnectionLine.indexOf(this.jobEntry.getDatabaseMeta() != null ? this.jobEntry.getDatabaseMeta().getName() : "");
        if (index >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.jobEntry.getCubeName() != null) {
            this.textCubeName.setText(this.jobEntry.getCubeName());
        }
        this.tableViewFields.table.removeAll();
        if (this.jobEntry.getDimensionNames() != null && this.jobEntry.getDimensionNames().size() > 0) {
            for (String dimensionName : this.jobEntry.getDimensionNames()) {
                this.tableViewFields.add(new String[]{dimensionName});
            }
        }
        if (this.tableViewFields.table.getItemCount() == 0) {
            this.tableViewFields.add(new String[]{""});
        }
        this.tableViewFields.setRowNums();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        this.tableViewFields.removeEmptyRows();
        ArrayList<String> dimensionNames = new ArrayList<String>();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            dimensionNames.add(this.tableViewFields.table.getItem(i).getText(1));
        }
        this.jobEntry.setName(this.textStepName.getText());
        this.jobEntry.setDatabaseMeta(DatabaseMeta.findDatabase((List)this.jobMeta.getDatabases(), (String)this.addConnectionLine.getText()));
        this.jobEntry.setCubeName(this.textCubeName.getText());
        this.jobEntry.setDimensionNames(dimensionNames);
        this.dispose();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

