/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.celloutput;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputData;
import org.pentaho.di.trans.steps.palo.celloutput.PaloCellOutputMeta;

public class PaloCellOutput
extends BaseStep
implements StepInterface {
    private PaloCellOutputMeta meta;
    private PaloCellOutputData data;

    public PaloCellOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block15: {
            this.meta = (PaloCellOutputMeta)smi;
            this.data = (PaloCellOutputData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.logDebug("No More Rows.");
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.logBasic("First Row Analysis.");
                this.data.indexes = new int[this.meta.getFields().size() + 1];
                for (int i = 0; i < this.data.indexes.length - 1; ++i) {
                    this.data.indexes[i] = this.getInputRowMeta().indexOfValue(this.meta.getFields().get(i).getFieldName());
                }
                this.data.indexes[this.data.indexes.length - 1] = this.getInputRowMeta().indexOfValue(this.meta.getMeasure().getFieldName());
                this.logBasic("First Row Ok.");
                if (this.meta.getClearCube()) {
                    try {
                        this.data.helper.clearCube(this.meta.getCube());
                    }
                    catch (Exception ex) {
                        throw new KettleException("Failed to clear Cube");
                    }
                }
            }
            String row = "";
            try {
                int i;
                Object[] newRow = new Object[this.meta.getFields().size() + 1];
                for (i = 0; i < this.data.indexes.length; ++i) {
                    if (i == this.data.indexes.length - 1) {
                        if (this.meta.getMeasureType().equals("Numeric")) {
                            newRow[i] = this.getInputRowMeta().getNumber(r, this.data.indexes[i]);
                            continue;
                        }
                        newRow[i] = this.getInputRowMeta().getString(r, this.data.indexes[i]);
                        continue;
                    }
                    newRow[i] = this.getInputRowMeta().getString(r, this.data.indexes[i]);
                }
                this.data.batchCache.add(newRow);
                if (this.data.batchCache.size() != this.meta.getCommitSize()) break block15;
                try {
                    this.data.helper.addCells(this.data.batchCache, this.meta.getUpdateMode(), this.meta.getSplashMode());
                    for (i = 0; i < this.data.batchCache.size(); ++i) {
                        this.incrementLinesOutput();
                    }
                }
                finally {
                    this.data.batchCache.clear();
                }
            }
            catch (Exception e) {
                throw new KettleException("Failed to add Cell Row: " + row, (Throwable)e);
            }
        }
        return true;
    }

    public final boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloCellOutputMeta)smi;
        this.data = (PaloCellOutputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Meta Fields: " + this.meta.getFields().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta(), this.getLogLevel());
                this.data.helper.connect();
                this.data.helper.loadCubeCache(this.meta.getCube(), this.meta.getEnableDimensionCache(), this.meta.getPreloadDimensionCache());
                this.data.batchCache.clear();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.getErrors() == 0L && this.data.batchCache.size() > 0) {
                this.data.helper.addCells(this.data.batchCache, this.meta.getUpdateMode(), this.meta.getSplashMode());
                for (int i = 0; i < this.data.batchCache.size(); ++i) {
                    this.incrementLinesOutput();
                }
            }
        }
        catch (Exception ex) {
            this.logError("Unexpected error processing batch error", ex);
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.data.batchCache.clear();
            this.data.helper.clearCubeCache();
            this.data.helper.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

