/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StringTranslator;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.UnicodeUtil;
import java.sql.SQLException;

public class UnicodeStringTranslator
extends StringTranslator {
    public UnicodeStringTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte[] byArray = structuredMem.getBytes(this.bufpos, this.logicalLength * 2);
            string = StringUtil.trimLeft(UnicodeUtil.bigUnicode2String(byArray));
        }
        return string;
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return byArray;
        }
        this.checkFieldLimits(byArray.length);
        return byArray;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = UnicodeUtil.char2BigUnicode(cArray);
        this.checkFieldLimits(byArray.length);
        return byArray;
    }

    protected void putSpecific(DataPart dataPart, Object object) {
        dataPart.putInt1(1, this.bufpos - 1);
        dataPart.putUnicodeBytes((byte[])object, this.bufpos, this.physicalLength - 1);
    }
}

