/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.SQLException;

class StringTranslator
extends CharDataTranslator {
    StringTranslator(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getString(sQLParamController, structuredMem);
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        BigDecimal bigDecimal = null;
        if (string == null) {
            bigDecimal = new BigDecimal(0.0);
        } else {
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    bigDecimal = new BigDecimal(string.trim());
                }
                catch (NumberFormatException numberFormatException2) {
                    throw this.newParseException(string, "BigDecimal");
                }
            }
        }
        return bigDecimal;
    }

    public boolean getBoolean(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return false;
        }
        Boolean bl = Boolean.valueOf(string);
        if (bl.booleanValue()) {
            return true;
        }
        try {
            double d = Double.parseDouble(string);
            return d != 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string != null) {
            return string.getBytes();
        }
        return null;
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Byte(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public Reader getCharacterStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        String string = this.getString(sQLParamController, structuredMem);
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        return stringReader;
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Double(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Float(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public int getInt(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Int(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public long getLong(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Long(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public short getShort(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.bigDecimal2Short(this.getBigDecimal(sQLParamController, structuredMem));
    }

    public String getString(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        String string = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            string = structuredMem.getStrippedString(this.bufpos, this.logicalLength);
        }
        return string;
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        return this.transStringForInput(new String(byArray));
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            char[] cArray = new char[n];
            int n2 = reader.read(cArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                char[] cArray2 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray2, 0, cArray, 0, n2);
            }
            return this.transStringForInput(new String(cArray));
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            return this.transBytesForInput(byArray);
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    protected Object transSpecificForInput(Object object) throws SQLException {
        return null;
    }

    public Object transStringForInput(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        byte[] byArray = StringUtil.bytes_iso8859_1(string);
        this.checkFieldLimits(byArray.length);
        return string;
    }
}

