/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.locator.impl.repository;

import java.util.Collection;
import java.util.Optional;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.service.PluginServiceLoader;
import org.pentaho.di.core.service.ServiceProvider;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.kettle.repository.locator.api.KettleRepositoryLocator;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.locator.api.MetastoreProvider;

@ServiceProvider(id="RepositoryMetastoreProvider", description="Provides access to a local file metastore", provides=MetastoreProvider.class)
public class RepositoryMetastoreProvider
implements MetastoreProvider,
ServiceProviderInterface<MetastoreProvider> {
    private KettleRepositoryLocator kettleRepositoryLocator;

    public RepositoryMetastoreProvider(KettleRepositoryLocator kettleRepositoryLocator) {
        this.kettleRepositoryLocator = kettleRepositoryLocator;
    }

    public RepositoryMetastoreProvider() {
        try {
            Collection repositoryLocators = PluginServiceLoader.loadServices(KettleRepositoryLocator.class);
            Optional kettleRepositoryLocatorOptional = repositoryLocators.stream().findFirst();
            if (kettleRepositoryLocatorOptional.isPresent()) {
                this.kettleRepositoryLocator = repositoryLocators.stream().findFirst().orElse(null);
            }
        }
        catch (KettlePluginException e) {
            e.printStackTrace();
        }
    }

    public IMetaStore getMetastore() {
        Repository repository;
        if (this.kettleRepositoryLocator != null && (repository = this.kettleRepositoryLocator.getRepository()) != null) {
            return repository.getMetaStore();
        }
        return null;
    }

    public String getProviderType() {
        return "RepositoryMetastoreProvider";
    }
}

