/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.locator.impl.local;

import com.google.common.annotations.VisibleForTesting;
import org.pentaho.di.core.service.ServiceProvider;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.locator.api.MetastoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceProvider(id="LocalFileMetastoreProvider", description="Provides access to a local file metastore", provides=MetastoreProvider.class)
public class LocalFileMetastoreProvider
implements MetastoreProvider,
ServiceProviderInterface<MetastoreProvider> {
    private static final Logger logger = LoggerFactory.getLogger(LocalFileMetastoreProvider.class);
    private final MetastoreSupplier supplier;

    public LocalFileMetastoreProvider() {
        this(MetaStoreConst::openLocalPentahoMetaStore);
    }

    public LocalFileMetastoreProvider(MetastoreSupplier supplier) {
        this.supplier = supplier;
    }

    public IMetaStore getMetastore() {
        try {
            return this.supplier.getMetastore();
        }
        catch (MetaStoreException e) {
            logger.error("Unable to open local metastore", (Throwable)e);
            return null;
        }
    }

    public String getProviderType() {
        return "LocalMetastoreProvider";
    }

    @VisibleForTesting
    static interface MetastoreSupplier {
        public IMetaStore getMetastore() throws MetaStoreException;
    }
}

