/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.locator.api.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.osgi.api.MetastoreLocatorOsgi;
import org.pentaho.di.core.service.PluginServiceLoader;
import org.pentaho.di.core.service.ServiceProvider;
import org.pentaho.di.core.service.ServiceProviderInterface;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.locator.api.MetastoreLocator;
import org.pentaho.metastore.locator.api.MetastoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceProvider(id="MetastoreLocator", description="Provides access to the metastore", provides=MetastoreLocator.class)
public class MetastoreLocatorImpl
implements MetastoreLocator,
MetastoreLocatorOsgi,
ServiceProviderInterface<MetastoreLocator> {
    private static Map<String, MetastoreProvider> providerMap = new ConcurrentHashMap<String, MetastoreProvider>();
    private Logger logger = LoggerFactory.getLogger(MetastoreLocatorImpl.class);

    public IMetaStore getExplicitMetastore(String providerKey) {
        try {
            for (MetastoreProvider provider : PluginServiceLoader.loadServices(MetastoreProvider.class)) {
                if (!provider.getProviderType().equals(providerKey)) continue;
                return provider.getMetastore();
            }
        }
        catch (KettlePluginException e) {
            this.logger.error("Exception loading MetastoreProvider services", (Throwable)e);
        }
        MetastoreProvider embeddedProvider = providerMap.get(providerKey);
        if (null != embeddedProvider) {
            return embeddedProvider.getMetastore();
        }
        return null;
    }

    public IMetaStore getMetastore() {
        return this.getMetastore(null);
    }

    public IMetaStore getMetastore(String providerKey) {
        IMetaStore metaStore = this.getExplicitMetastore("RepositoryMetastoreProvider");
        if (metaStore == null) {
            metaStore = this.getExplicitMetastore("LocalMetastoreProvider");
        }
        if (metaStore == null && providerKey != null) {
            metaStore = this.getExplicitMetastore(providerKey);
        }
        if (metaStore == null) {
            try {
                metaStore = MetaStoreConst.openLocalPentahoMetaStore((boolean)false);
            }
            catch (MetaStoreException e) {
                LogChannel.GENERAL.logError("Could not load Metastore.", (Throwable)e);
                return null;
            }
        }
        return metaStore;
    }

    public String setEmbeddedMetastore(final IMetaStore metastore) {
        MetastoreProvider metastoreProvider = new MetastoreProvider(){

            public IMetaStore getMetastore() {
                return metastore;
            }

            public String getProviderType() {
                return null;
            }
        };
        try {
            String providerKey;
            String string = providerKey = metastore.getName() == null ? UUID.randomUUID().toString() : metastore.getName();
            if (this.getExplicitMetastore(providerKey) == null) {
                providerMap.put(providerKey, metastoreProvider);
            }
            return providerKey;
        }
        catch (MetaStoreException e) {
            throw new IllegalStateException(e);
        }
    }

    public void disposeMetastoreProvider(String providerKey) {
        providerMap.remove(providerKey);
    }
}

