/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ContentOutputAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.ContentOutputComponent";
    public static final String CONTENT_INPUT_ELEMENT = "CONTENTOUTPUT";
    public static final String CONTENT_OUTPUT_ELEMENT = "content";
    public static final String MIME_TYPE_ELEMENT = "mime-type";
    public static final String CONTENT_INPUT = "input";
    public static final String CONTENT_OUTPUT = "output";
    protected static final String[] EXPECTED_INPUTS = new String[]{"CONTENTOUTPUT", "mime-type"};

    public ContentOutputAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public ContentOutputAction() {
        super(COMPONENT_NAME);
    }

    @Override
    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public void setMimeType(IActionInputSource value) {
        this.setActionInputValue(MIME_TYPE_ELEMENT, value);
    }

    public IActionInput getMimeType() {
        return this.getInput(MIME_TYPE_ELEMENT);
    }

    public void setInput(IActionInputVariable value) {
        this.setActionInputValue(CONTENT_INPUT_ELEMENT, value);
    }

    public IActionInput getInput() {
        return this.getInput(CONTENT_INPUT_ELEMENT);
    }

    public IActionOutput getOutput() {
        return this.getOutput(CONTENT_OUTPUT_ELEMENT);
    }

    public void setOutput(String outputPublicName) {
        this.setOutput(CONTENT_OUTPUT_ELEMENT, outputPublicName, CONTENT_OUTPUT_ELEMENT);
    }

    @Override
    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(CONTENT_INPUT_ELEMENT);
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing content input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Content input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Content input is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateInput(MIME_TYPE_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing content mime type parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Content mime type input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Content mime type input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateOutput(CONTENT_OUTPUT)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing content ouput parameter.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && ContentOutputAction.hasComponentName(element, COMPONENT_NAME);
    }
}

