/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceInput;
import org.pentaho.actionsequence.dom.IActionSequenceInput;
import org.pentaho.actionsequence.dom.IActionSequenceInputSource;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionSequenceInputSource
implements IActionSequenceInputSource {
    Element sourceElement;
    IActionParameterMgr actionInputProvider;

    protected ActionSequenceInputSource(Element element, IActionParameterMgr actionInputProvider) {
        this.sourceElement = element;
        this.actionInputProvider = actionInputProvider;
    }

    @Override
    public void setOrigin(String origin) {
        this.sourceElement.setName(origin);
        ActionSequenceDocument.fireIoChanged(this.getActionSequenceInput());
    }

    @Override
    public String getOrigin() {
        return this.sourceElement.getName();
    }

    @Override
    public void setName(String name) {
        this.sourceElement.setText(name);
        ActionSequenceDocument.fireIoChanged(this.getActionSequenceInput());
    }

    @Override
    public String getName() {
        return this.sourceElement.getText();
    }

    @Override
    public IActionSequenceInput getActionSequenceInput() {
        Element ancestorElement;
        ActionSequenceInput actionSequenceInput = null;
        if (this.sourceElement != null && (ancestorElement = this.sourceElement.getParent()) != null && (ancestorElement = ancestorElement.getParent()) != null) {
            actionSequenceInput = new ActionSequenceInput(ancestorElement, this.actionInputProvider);
        }
        return actionSequenceInput;
    }

    @Override
    public void delete() {
        Document doc = this.sourceElement.getDocument();
        if (doc != null) {
            IActionSequenceInput actionSequenceInput = this.getActionSequenceInput();
            this.sourceElement.detach();
            ActionSequenceDocument.fireIoChanged(actionSequenceInput);
        }
    }
}

