/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.ftp4che.commands.Command;
import org.ftp4che.commands.ListCommand;
import org.ftp4che.commands.RetrieveCommand;
import org.ftp4che.commands.StoreCommand;
import org.ftp4che.event.FTPEvent;
import org.ftp4che.event.FTPListener;
import org.ftp4che.exception.AuthenticationNotSupportedException;
import org.ftp4che.exception.ConfigurationException;
import org.ftp4che.exception.FtpFileNotFoundException;
import org.ftp4che.exception.FtpIOException;
import org.ftp4che.exception.FtpWorkflowException;
import org.ftp4che.exception.NotConnectedException;
import org.ftp4che.exception.UnkownReplyStateException;
import org.ftp4che.io.ReplyWorker;
import org.ftp4che.io.SocketProvider;
import org.ftp4che.proxy.Proxy;
import org.ftp4che.reply.Reply;
import org.ftp4che.reply.ReplyCode;
import org.ftp4che.util.ReplyFormatter;
import org.ftp4che.util.ftpfile.FTPFile;
import org.ftp4che.util.ftpfile.FTPFileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FTPConnection {
    protected EventListenerList listenerList = new EventListenerList();
    public static final int FTP_CONNECTION = 1;
    public static final int IMPLICIT_SSL_FTP_CONNECTION = 2;
    public static final int AUTH_SSL_FTP_CONNECTION = 3;
    public static final int AUTH_TLS_FTP_CONNECTION = 4;
    public static final int IMPLICIT_TLS_FTP_CONNECTION = 5;
    public static final int IMPLICIT_TLS_WITH_CRYPTED_DATA_FTP_CONNECTION = 6;
    public static final int IMPLICIT_SSL_WITH_CRYPTED_DATA_FTP_CONNECTION = 7;
    public static final int MAX_DOWNLOAD_BANDWIDTH = Integer.MAX_VALUE;
    public static final int MAX_UPLOAD_BANDWIDTH = Integer.MAX_VALUE;
    public static final int CONNECTED = 1001;
    public static final int DISCONNECTED = 1002;
    public static final int IDLE = 1003;
    public static final int BUSY = 1010;
    public static final int RECEIVING_FILE = 1004;
    public static final int SENDING_FILE = 1005;
    public static final int FXP_FILE = 1006;
    public static final int UNKNOWN = 9999;
    public static final int ERROR = 1011;
    public static final int RECEIVING_FILE_STARTED = 2001;
    public static final int RECEIVING_FILE_ENDED = 2002;
    public static final int SENDING_FILE_STARTED = 2003;
    public static final int SENDING_FILE_ENDED = 2004;
    public static final int FXPING_FILE_STARTED = 2005;
    public static final int FXPING_FILE_ENDED = 2006;
    public static final int CSL_DIRECT_CALL = 0;
    public static final int CSL_INDIRECT_CALL = 1;
    public static final int CSL_2WAY_INDIRECT_CALL = 2;
    private static final Logger log = Logger.getLogger((String)FTPConnection.class.getName());
    private int connectionType = 1;
    private String secureFXPType = null;
    private boolean sscnActive = false;
    private InetSocketAddress address = null;
    private String user = "";
    private String password = "";
    private String account = "";
    private boolean passiveMode = false;
    private int timeout = 10000;
    private int downloadBandwidth = Integer.MAX_VALUE;
    private int uploadBandwidth = Integer.MAX_VALUE;
    private Charset charset = Charset.forName("ISO-8859-1");
    private CharsetEncoder encoder = this.charset.newEncoder();
    private CharBuffer controlBuffer = CharBuffer.allocate(1024);
    protected SocketProvider socketProvider = null;
    private int connectionStatus = 9999;
    private int connectionStatusLock = 0;
    private Proxy proxy = null;
    protected FTPFileFactory factory;
    private String workingDirectory = null;
    private TrustManager[] trustManagers = new TrustManager[0];
    private KeyManager[] keyManagers = new KeyManager[0];
    private boolean tryResume = false;
    private boolean pretSupport = false;
    private boolean cpsvSupport = false;
    private boolean sscnSupport = false;
    private String connectionTransferType = "TYPE I";

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    protected String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    protected void setUser(String user) throws ConfigurationException {
        if (user == null || user.length() == 0) {
            throw new ConfigurationException("user must no be null or has a length of 0");
        }
        this.user = user;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public abstract void connect() throws NotConnectedException, IOException, AuthenticationNotSupportedException, FtpIOException, FtpWorkflowException;

    public void disconnect() {
        try {
            Command command = new Command("QUIT");
            this.sendCommand(command).dumpReply();
            this.socketProvider.close();
        }
        catch (IOException ioe) {
            log.warn((Object)("Error closing connection: " + this.getAddress().getHostName() + ":" + this.getAddress().getPort()), (Throwable)ioe);
        }
        this.socketProvider = null;
        this.setConnectionStatusLock(0);
        this.setConnectionStatus(1002);
    }

    public Reply sendCommand(Command cmd) throws IOException {
        if (this.getConnectionStatusLock() == 0) {
            this.setConnectionStatus(1010);
        }
        this.controlBuffer.clear();
        log.debug((Object)("Sending command: " + cmd.toString().substring(0, cmd.toString().length() - 2)));
        this.controlBuffer.put(cmd.toString());
        this.controlBuffer.flip();
        this.socketProvider.write(this.encoder.encode(this.controlBuffer));
        this.controlBuffer.clear();
        Reply reply = null;
        try {
            reply = ReplyWorker.readReply(this.socketProvider);
        }
        catch (IOException ioe) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw ioe;
        }
        if (this.getConnectionStatusLock() == 0) {
            this.setConnectionStatus(1003);
        }
        if (reply != null) {
            this.fireReplyMessageArrived(new FTPEvent(this, this.getConnectionStatus(), reply));
        }
        return reply;
    }

    public int getConnectionStatus() {
        return this.connectionStatus;
    }

    protected void setConnectionStatus(int connectionStatus) {
        this.connectionStatus = connectionStatus;
        this.fireConnectionStatusChanged(new FTPEvent(this, connectionStatus));
    }

    protected void setConnectionStatus(int connectionStatus, FTPFile fromFile, FTPFile toFile) {
        this.connectionStatus = connectionStatus;
        this.fireConnectionStatusChanged(new FTPEvent(this, connectionStatus, fromFile, toFile));
    }

    public int getConnectionStatusLock() {
        return this.connectionStatusLock;
    }

    protected void setConnectionStatusLock(int connectionStatusLock) {
        this.connectionStatusLock = connectionStatusLock;
    }

    protected void setTimeout(int millis) {
        this.timeout = millis;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    public void changeDirectory(String directory) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("CWD", directory);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        this.workingDirectory = null;
    }

    public String getWorkDirectory() throws IOException, UnkownReplyStateException, FtpWorkflowException, FtpIOException {
        if (this.workingDirectory == null) {
            Command command = new Command("PWD");
            Reply reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            this.workingDirectory = ReplyFormatter.parsePWDReply(reply);
        }
        return this.workingDirectory;
    }

    public void changeToParentDirectory() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("CDUP");
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
        this.workingDirectory = null;
    }

    public void makeDirectory(String pathname) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("MKD", pathname);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void removeDirectory(String pathname) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("RMD", pathname);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void noOperation() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("NOOP");
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public InetSocketAddress sendPassiveMode() throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("PASV");
        try {
            Reply reply = this.sendCommand(command);
            reply.dumpReply();
            reply.validate();
            return ReplyFormatter.parsePASVCommand(reply);
        }
        catch (UnkownReplyStateException urse) {
            log.error((Object)"The state of the reply from pasv command is unknown!", (Throwable)urse);
            return null;
        }
    }

    public void setPassiveMode(boolean mode) {
        this.passiveMode = mode;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public List<FTPFile> getDirectoryListing() throws IOException, FtpWorkflowException, FtpIOException {
        return this.getDirectoryListing(this.getWorkDirectory());
    }

    public List<FTPFile> getFastDirectoryListing() throws IOException, FtpWorkflowException, FtpIOException {
        String workDirectory = this.getWorkDirectory();
        Command command = new Command("STAT", "-LA");
        Reply reply = this.sendCommand(command);
        reply.validate();
        return this.factory.parse(reply.getLines(), workDirectory);
    }

    public List<FTPFile> getFastDirectoryListing(String directory) throws IOException, FtpWorkflowException, FtpIOException {
        Command command = new Command("STAT", "-LA", directory);
        Reply reply = this.sendCommand(command);
        reply.validate();
        return this.factory.parse(reply.getLines(), directory);
    }

    public List<FTPFile> getDirectoryListing(String directory) throws IOException, FtpWorkflowException, FtpIOException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(1010);
        ListCommand command = new ListCommand(directory);
        SocketProvider provider = null;
        String workDirectory = this.getWorkDirectory();
        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
            Command pbsz = new Command("PBSZ", "0");
            this.sendCommand(pbsz).dumpReply();
            Command prot = new Command("PROT", "P");
            this.sendCommand(prot).dumpReply();
        }
        Reply commandReply = new Reply();
        provider = this.isPassiveMode() ? this.initDataSocket(command, commandReply) : this.sendPortCommand(command, commandReply);
        command.setDataSocket(provider);
        List<FTPFile> parsedList = null;
        try {
            parsedList = this.factory.parse(command.fetchDataConnectionReply().getLines(), workDirectory);
        }
        catch (IOException ioe) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw ioe;
        }
        if (commandReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw ioe;
            }
        }
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
        return parsedList;
    }

    public SocketProvider sendPortCommand(Command command, Reply commandReply) throws IOException, FtpWorkflowException, FtpIOException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(1010);
        SocketProvider provider = null;
        if (this.getProxy() == null) {
            ServerSocket server = ServerSocketFactory.getDefault().createServerSocket();
            InetSocketAddress isa = new InetSocketAddress(this.socketProvider.socket().getLocalAddress(), 0);
            server.bind(isa);
            int port = server.getLocalPort();
            StringBuffer modifiedHost = new StringBuffer();
            modifiedHost.append(server.getInetAddress().getHostAddress().replace('.', ','));
            modifiedHost.append(",");
            modifiedHost.append(port >> 8);
            modifiedHost.append(",");
            modifiedHost.append(port & 0xFF);
            Command portCommand = new Command("PORT", modifiedHost.toString());
            Reply portReply = this.sendCommand(portCommand);
            portReply.dumpReply();
            portReply.validate();
            commandReply.setLines(this.sendCommand(command).getLines());
            commandReply.dumpReply();
            commandReply.validate();
            provider = new SocketProvider(server.accept(), false, this.getDownloadBandwidth(), this.getUploadBandwidth());
        } else {
            InetSocketAddress portSocketAddress = new InetSocketAddress(this.getAddress().getAddress(), 0);
            Socket proxySocket = this.getProxy().bind(portSocketAddress);
            int port = this.getProxy().getBindAddress().getPort();
            StringBuffer modifiedHost = new StringBuffer();
            modifiedHost.append(this.getProxy().getProxyAddress().getAddress().getHostAddress().replace('.', ','));
            modifiedHost.append(",");
            modifiedHost.append(port >> 8);
            modifiedHost.append(",");
            modifiedHost.append(port & 0xFF);
            Command portCommand = new Command("PORT", modifiedHost.toString());
            Reply portReply = this.sendCommand(portCommand);
            portReply.dumpReply();
            portReply.validate();
            commandReply.setLines(this.sendCommand(command).getLines());
            commandReply.dumpReply();
            commandReply.validate();
            provider = new SocketProvider(proxySocket, false, this.getDownloadBandwidth(), this.getUploadBandwidth());
        }
        provider.socket().setReceiveBufferSize(65536);
        provider.socket().setSendBufferSize(65536);
        provider.setSSLMode(this.getConnectionType());
        if (this.connectionType == 4 || this.connectionType == 3 || this.connectionType == 7 || this.connectionType == 6) {
            provider.negotiate(this.getTrustManagers(), this.getKeyManagers());
        }
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
        return provider;
    }

    public void downloadFile(FTPFile fromFile, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.downloadFile(fromFile, toFile, false);
    }

    public void downloadFile(FTPFile fromFile, FTPFile toFile, boolean resume) throws IOException, FtpWorkflowException, FtpIOException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(2001, fromFile, toFile);
        this.setConnectionStatus(1004);
        RetrieveCommand command = new RetrieveCommand("RETR", fromFile, toFile);
        SocketProvider provider = null;
        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
            Command pbsz = new Command("PBSZ", "0");
            this.sendCommand(pbsz).dumpReply();
            Command prot = new Command("PROT", "P");
            this.sendCommand(prot).dumpReply();
        }
        if (resume || this.tryResume) {
            if (fromFile.getSize() <= 0L) {
                List<FTPFile> list = this.getDirectoryListing(fromFile.getPath());
                for (FTPFile file : list) {
                    if (!file.getName().equals(fromFile.getName())) continue;
                    fromFile.setSize(file.getSize());
                }
            }
            if (fromFile.getSize() != toFile.getSize()) {
                command.setResumePosition(toFile.getSize());
                Command resumeCommand = new Command("REST", "" + toFile.getSize());
                Reply resumeReply = this.sendCommand(resumeCommand);
                resumeReply.dumpReply();
                try {
                    resumeReply.validate();
                }
                catch (FtpWorkflowException fwe) {
                    log.error((Object)("Couldn't resume file, error was: " + fwe.getMessage()));
                }
                catch (FtpIOException fioe) {
                    log.error((Object)("Couldn't resume file, error was: " + fioe.getMessage()));
                }
            } else {
                return;
            }
        }
        Command commandType = new Command(this.connectionTransferType);
        this.sendCommand(commandType).dumpReply();
        Reply commandReply = new Reply();
        provider = this.isPassiveMode() ? this.initDataSocket(command, commandReply) : this.sendPortCommand(command, commandReply);
        command.setDataSocket(provider);
        try {
            command.fetchDataConnectionReply();
        }
        catch (IOException ioe) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw ioe;
        }
        if (commandReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw ioe;
            }
        }
        this.setConnectionStatus(2002, fromFile, toFile);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public InputStream downloadStream(FTPFile fromFile) throws IOException, FtpWorkflowException, FtpIOException {
        PipedInputStream pis = new PipedInputStream();
        class DownStreamingThread
        extends Thread {
            FTPConnection connection;
            FTPFile fromFile;
            PipedInputStream pis;

            public DownStreamingThread(FTPConnection connection, FTPFile fromFile, PipedInputStream pis) {
                this.connection = connection;
                this.fromFile = fromFile;
                this.pis = pis;
            }

            public void run() {
                try {
                    this.connection.streamFile(this.fromFile, this.pis);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        new DownStreamingThread(this, fromFile, pis).start();
        try {
            for (int i = 0; i < 60 && pis.available() <= 0; ++i) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pis;
    }

    private void streamFile(FTPFile fromFile, PipedInputStream pis) throws IOException, FtpWorkflowException, FtpIOException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(2001, fromFile, null);
        this.setConnectionStatus(1004);
        RetrieveCommand command = new RetrieveCommand("RETR", fromFile, pis);
        SocketProvider provider = null;
        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
            Command pbsz = new Command("PBSZ", "0");
            this.sendCommand(pbsz).dumpReply();
            Command prot = new Command("PROT", "P");
            this.sendCommand(prot).dumpReply();
        }
        Command commandType = new Command(this.connectionTransferType);
        this.sendCommand(commandType).dumpReply();
        Reply commandReply = new Reply();
        provider = this.isPassiveMode() ? this.initDataSocket(command, commandReply) : this.sendPortCommand(command, commandReply);
        command.setDataSocket(provider);
        try {
            command.fetchDataConnectionReply(1);
        }
        catch (IOException ioe) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw ioe;
        }
        if (commandReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw ioe;
            }
        }
        this.setConnectionStatus(2002, fromFile, null);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void downloadDirectory(FTPFile srcDir, FTPFile dstDir) throws IOException, FtpWorkflowException, FtpIOException {
        if (!srcDir.isDirectory()) {
            throw new FtpFileNotFoundException("Downloading: " + srcDir.getName() + " is not possible, it's not a directory!");
        }
        new File(dstDir.toString()).mkdir();
        String listDir = srcDir.toString();
        listDir = listDir.endsWith("/") ? listDir.substring(0, listDir.length() - 1) : listDir;
        List<FTPFile> files = this.getDirectoryListing(listDir);
        Collections.sort(files);
        for (FTPFile file : files) {
            file.setPath(srcDir.toString());
            if (!file.isDirectory()) {
                this.downloadFile(file, new FTPFile(dstDir.toString(), file.getName(), false));
                continue;
            }
            this.downloadDirectory(file, new FTPFile(dstDir.toString(), file.getName(), true));
        }
    }

    public void uploadFile(FTPFile fromFile, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.uploadFile(fromFile, toFile, false);
    }

    public void uploadFile(FTPFile fromFile, FTPFile toFile, boolean resume) throws IOException, FtpWorkflowException, FtpIOException {
        this.upload(fromFile, toFile, resume);
    }

    public void uploadStream(InputStream upStream, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.upload(upStream, toFile, false);
    }

    private void upload(Object upSrc, FTPFile toFile, boolean resume) throws IOException, FtpWorkflowException, FtpIOException {
        FTPFile srcInfo = null;
        if (upSrc instanceof FTPFile) {
            srcInfo = (FTPFile)upSrc;
        } else if (upSrc instanceof InputStream && resume) {
            resume = false;
            log.warn((Object)"No resume possible on uploadStream");
        }
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(2003, srcInfo, toFile);
        this.setConnectionStatus(1005);
        StoreCommand command = new StoreCommand("STOR", upSrc, toFile);
        SocketProvider provider = null;
        if (this.getConnectionType() == 3 || this.getConnectionType() == 4) {
            Command pbsz = new Command("PBSZ", "0");
            this.sendCommand(pbsz).dumpReply();
            Command prot = new Command("PROT", "P");
            this.sendCommand(prot).dumpReply();
        }
        if (resume || this.tryResume) {
            if (toFile.getSize() <= 0L) {
                List<FTPFile> list = this.getDirectoryListing(toFile.getPath());
                for (FTPFile file : list) {
                    if (!file.getName().equals(toFile.getName())) continue;
                    toFile.setSize(file.getSize());
                }
            }
            if (srcInfo.getSize() != toFile.getSize()) {
                command.setResumePosition(toFile.getSize());
                Command resumeCommand = new Command("REST", "" + toFile.getSize());
                Reply resumeReply = this.sendCommand(resumeCommand);
                resumeReply.dumpReply();
                try {
                    resumeReply.validate();
                }
                catch (FtpWorkflowException fwe) {
                    log.error((Object)("Couldn't resume file, error was: " + fwe.getMessage()));
                }
                catch (FtpIOException fioe) {
                    log.error((Object)("Couldn't resume file, error was: " + fioe.getMessage()));
                }
            } else {
                return;
            }
        }
        Command commandType = new Command(this.connectionTransferType);
        this.sendCommand(commandType).dumpReply();
        Reply commandReply = new Reply();
        provider = this.isPassiveMode() ? this.initDataSocket(command, commandReply) : this.sendPortCommand(command, commandReply);
        command.setDataSocket(provider);
        try {
            command.fetchDataConnectionReply();
        }
        catch (IOException ioe) {
            this.setConnectionStatus(1011);
            this.disconnect();
            throw ioe;
        }
        if (commandReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw ioe;
            }
        }
        this.setConnectionStatus(2004, srcInfo, toFile);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void uploadDirectory(FTPFile srcDir, FTPFile dstDir) throws IOException, FtpWorkflowException, FtpIOException {
        if (!srcDir.isDirectory()) {
            throw new FtpFileNotFoundException("Uploading: " + srcDir.getName() + " is not possible, it's not a directory!");
        }
        this.makeDirectory(dstDir.toString());
        File[] files = srcDir.getFile().listFiles();
        ArrayList<FTPFile> ftpFiles = new ArrayList<FTPFile>();
        for (File file : files) {
            ftpFiles.add(new FTPFile(file));
        }
        Collections.sort(ftpFiles);
        for (FTPFile file : ftpFiles) {
            if (!file.isDirectory()) {
                this.uploadFile(file, new FTPFile(dstDir.toString(), file.getName()));
                continue;
            }
            this.uploadDirectory(file, new FTPFile(dstDir.toString(), file.getName(), true));
        }
    }

    public void fxpFile(FTPConnection destination, FTPFile fromFile, FTPFile toFile) throws IOException, FtpWorkflowException, FtpIOException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(2005, fromFile, toFile);
        this.setConnectionStatus(1006);
        if (this.isPretSupport()) {
            Command pretCommand = new Command("PRET", "RETR", fromFile.toString());
            Reply pretReply = this.sendCommand(pretCommand);
            pretReply.dumpReply();
            pretReply.validate();
        }
        if (destination.isPretSupport()) {
            Command pretDestCommand = new Command("PRET", "STOR", fromFile.toString());
            Reply pretDestReply = destination.sendCommand(pretDestCommand);
            pretDestReply.dumpReply();
            pretDestReply.validate();
        }
        Command pasvCommand = new Command("PASV");
        if (this.getSecureFXPType() == "SSCN" && !this.sscnActive) {
            this.setSSCNFxp(true);
            this.sscnActive = true;
            pasvCommand = new Command("PASV");
        } else if (this.getSecureFXPType() == "CPSV") {
            pasvCommand = new Command("CPSV");
        }
        Reply pasvReply = this.sendCommand(pasvCommand);
        pasvReply.dumpReply();
        pasvReply.validate();
        List<String> lines = pasvReply.getLines();
        if (lines.size() != 1) {
            throw new UnkownReplyStateException("PASV Reply has to have a size of 1 entry but it has: " + lines.size());
        }
        String line = lines.get(0);
        line = line.substring(line.indexOf(40) + 1, line.lastIndexOf(41));
        if (this.getSecureFXPType() == "CPSV") {
            Command protCommand = new Command("PROT", "P");
            Reply protReply = destination.sendCommand(protCommand);
            protReply.dumpReply();
            protReply.validate();
            protReply = this.sendCommand(protCommand);
            protReply.dumpReply();
            protReply.validate();
        }
        Command portCommand = new Command("PORT", line);
        Reply portReply = destination.sendCommand(portCommand);
        portReply.dumpReply();
        portReply.validate();
        Command storeCommand = new Command("STOR", toFile.toString());
        Reply storeReply = destination.sendCommand(storeCommand);
        storeReply.dumpReply();
        storeReply.validate();
        Command retrCommand = new Command("RETR", fromFile.toString());
        Reply retrReply = this.sendCommand(retrCommand);
        retrReply.dumpReply();
        retrReply.validate();
        if (retrReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(this.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                this.setConnectionStatus(1011);
                this.disconnect();
                throw ioe;
            }
        }
        if (storeReply.getLines().size() == 1) {
            try {
                ReplyWorker.readReply(destination.socketProvider).dumpReply();
            }
            catch (IOException ioe) {
                destination.setConnectionStatus(1011);
                destination.disconnect();
                throw ioe;
            }
        }
        if (this.getSecureFXPType() == "CPSV") {
            Command protCommand = new Command("PROT", "O");
            Reply protReply = destination.sendCommand(protCommand);
            protReply.dumpReply();
            protReply.validate();
            protReply = this.sendCommand(protCommand);
            protReply.dumpReply();
            protReply.validate();
        }
        if (this.getSecureFXPType() == "SSCN" && this.sscnActive) {
            this.setSSCNFxp(false);
            this.sscnActive = false;
        }
        this.setConnectionStatus(2006, fromFile, toFile);
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void fxpDirectory(FTPConnection destination, FTPFile srcDir, FTPFile dstDir) throws IOException, FtpWorkflowException, FtpIOException {
        if (!srcDir.isDirectory()) {
            throw new FtpFileNotFoundException("Downloading: " + srcDir.getName() + " is not possible, it's not a directory!");
        }
        if (this.getSecureFXPType() == "SSCN" && !this.sscnActive) {
            this.setSSCNFxp(true);
            this.sscnActive = true;
        }
        destination.makeDirectory(dstDir.toString());
        String listDir = srcDir.toString();
        listDir = listDir.endsWith("/") ? listDir.substring(0, listDir.length() - 1) : listDir;
        List<FTPFile> files = this.getDirectoryListing(listDir);
        Collections.sort(files);
        for (FTPFile file : files) {
            file.setPath(srcDir.toString());
            if (!file.isDirectory()) {
                this.fxpFile(destination, file, new FTPFile(dstDir.toString(), file.getName()));
                continue;
            }
            this.fxpDirectory(destination, file, new FTPFile(dstDir.toString(), file.getName(), true));
        }
        if (this.getSecureFXPType() == "SSCN" && this.sscnActive) {
            this.setSSCNFxp(false);
            this.sscnActive = false;
        }
    }

    private SocketProvider initDataSocket(Command command, Reply commandReply) throws IOException, FtpIOException, FtpWorkflowException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(1010);
        if (this.isPretSupport()) {
            Command pretCommand = new Command("PRET", command.toString());
            this.sendCommand(pretCommand).dumpReply();
        }
        InetSocketAddress dataSocket = this.sendPassiveMode();
        SocketProvider provider = new SocketProvider(false);
        provider.connect(dataSocket, this.getProxy(), this.getDownloadBandwidth(), this.getUploadBandwidth());
        provider.setSSLMode(this.getConnectionType());
        commandReply.setLines(this.sendCommand(command).getLines());
        commandReply.dumpReply();
        commandReply.validate();
        if (this.connectionType == 4 || this.connectionType == 3 || this.connectionType == 7 || this.connectionType == 6) {
            provider.negotiate(this.getTrustManagers(), this.getKeyManagers());
        }
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
        return provider;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    protected void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void sendSiteCommand(String commandParameter) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command("SITE", commandParameter);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    protected int getDownloadBandwidth() {
        return this.downloadBandwidth;
    }

    protected void setDownloadBandwidth(int maxDownloadBandwidth) {
        this.downloadBandwidth = maxDownloadBandwidth;
    }

    protected int getUploadBandwidth() {
        return this.uploadBandwidth;
    }

    protected void setUploadBandwidth(int maxUploadBandwidth) {
        this.uploadBandwidth = maxUploadBandwidth;
    }

    private boolean isListener(Class c, FTPListener f) {
        boolean isListener = false;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != c || listeners[i + 1] != f) continue;
            isListener = true;
        }
        return isListener;
    }

    public void addFTPStatusListener(FTPListener l) {
        this.listenerList.add(FTPListener.class, l);
    }

    public void removeFTPStatusListener(FTPListener l) {
        this.listenerList.remove(FTPListener.class, l);
    }

    public FTPListener[] getFTPStatusListeners() {
        return (FTPListener[])this.listenerList.getListeners(FTPListener.class);
    }

    protected void fireConnectionStatusChanged(FTPEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FTPListener.class) continue;
            if (event == null) {
                event = new FTPEvent(this, this.getConnectionStatus(), null);
            }
            ((FTPListener)listeners[i + 1]).connectionStatusChanged(event);
        }
    }

    protected void fireReplyMessageArrived(FTPEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FTPListener.class) continue;
            if (event == null) {
                event = new FTPEvent(this, this.getConnectionStatus(), null);
            }
            ((FTPListener)listeners[i + 1]).replyMessageArrived(event);
        }
    }

    public String getSecureFXPType() {
        return this.secureFXPType;
    }

    public void setSecureFXPType(String secureFXPType) {
        this.secureFXPType = secureFXPType;
    }

    public void setSSCNFxp(boolean active) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = null;
        command = active ? new Command("SSCN", "ON") : new Command("SSCN", "OFF");
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public boolean isSecuredFxp() throws IOException {
        Command command = new Command("SSCN");
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        return reply.getLines().get(0).indexOf("CLIENT") >= 0;
    }

    public void renameFile(FTPFile fromName, FTPFile toName) throws IOException, FtpIOException, FtpWorkflowException {
        this.setConnectionStatusLock(1);
        this.setConnectionStatus(1010);
        Command commandRenFr = new Command("RNFR", fromName.toString());
        Reply replyRenFr = this.sendCommand(commandRenFr);
        replyRenFr.dumpReply();
        replyRenFr.validate();
        Command commandRenTo = new Command("RNTO", toName.toString());
        Reply replyRenTo = this.sendCommand(commandRenTo);
        replyRenTo.dumpReply();
        replyRenTo.validate();
        this.setConnectionStatus(1003);
        this.setConnectionStatusLock(0);
    }

    public void deleteFile(FTPFile file) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command("DELE", file.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void deleteDirectory(FTPFile directory) throws IOException, FtpIOException, FtpWorkflowException {
        if (!directory.isDirectory()) {
            throw new FtpFileNotFoundException("Deleting: " + directory.getName() + " is not possible, it's not a directory!");
        }
        List<FTPFile> files = this.getDirectoryListing(directory.toString());
        Collections.sort(files);
        for (FTPFile file : files) {
            file.setPath(directory.toString());
            if (!file.isDirectory()) {
                this.deleteFile(file);
                continue;
            }
            this.deleteDirectory(file);
        }
        this.removeDirectory(directory);
    }

    public void removeDirectory(FTPFile directory) throws IOException, FtpIOException, FtpWorkflowException {
        Command command = new Command("RMD", directory.toString());
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public void setTransferType(boolean type) throws IOException, FtpIOException, FtpWorkflowException {
        this.connectionTransferType = type ? "TYPE I" : "TYPE A";
        Command command = new Command(this.connectionTransferType);
        Reply reply = this.sendCommand(command);
        reply.dumpReply();
        reply.validate();
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void checkSystem() throws IOException, FtpIOException {
        try {
            Command system = new Command("SYST");
            Reply reply = this.sendCommand(system);
            reply.dumpReply();
            reply.validate();
            this.factory = new FTPFileFactory(reply.getLines().get(0));
        }
        catch (FtpWorkflowException fwe) {
            this.factory = new FTPFileFactory("UNKNOWN");
        }
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public boolean isTryResume() {
        return this.tryResume;
    }

    public void setTryResume(boolean tryResume) {
        this.tryResume = tryResume;
    }

    public Date getModificationTime(FTPFile file) throws IOException, FtpIOException, FtpWorkflowException, ParseException {
        Command mdtm = new Command("MDTM", file.toString());
        Reply reply = this.sendCommand(mdtm);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseMDTMReply(reply);
    }

    public void setModificationTime(FTPFile file, Date date) throws IOException, FtpIOException, FtpWorkflowException, ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(date);
        Command mdtm = new Command("MDTM", dateString, file.toString());
        Reply reply = this.sendCommand(mdtm);
        reply.dumpReply();
        reply.validate();
    }

    public void setClientName(String name) throws FtpIOException, FtpWorkflowException, IOException {
        Command clnt = new Command("CLNT", name);
        Reply reply = this.sendCommand(clnt);
        reply.dumpReply();
        reply.validate();
    }

    public String getCRC(FTPFile file) throws FtpIOException, FtpWorkflowException, IOException {
        return this.getCRC(file, 0L, -1L);
    }

    public String getCRC(FTPFile file, long startposition, long endposition) throws FtpIOException, FtpWorkflowException, IOException {
        Command crc = new Command("XCRC", "\"" + file.toString() + "\"", "" + startposition, "" + endposition);
        Reply reply = this.sendCommand(crc);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseXCRCReply(reply);
    }

    public String getMD5(FTPFile file) throws FtpIOException, FtpWorkflowException, IOException {
        return this.getMD5(file, 0L, -1L);
    }

    public String getMD5(FTPFile file, long startposition, long endposition) throws FtpIOException, FtpWorkflowException, IOException {
        Command md5 = new Command("XMD5", "\"" + file.toString() + "\"", "" + startposition, "" + endposition);
        Reply reply = this.sendCommand(md5);
        reply.dumpReply();
        reply.validate();
        return ReplyFormatter.parseXMD5Reply(reply);
    }

    public boolean isPretSupport() {
        return this.pretSupport;
    }

    public void setPretSupport(boolean pretSupport) {
        this.pretSupport = pretSupport;
    }

    public void checkFeatures() throws IOException {
        Reply reply = this.sendCommand(new Command("FEAT"));
        reply.dumpReply();
        if (ReplyCode.isPositiveCompletionReply(reply)) {
            List<String> lines = reply.getLines();
            for (String s : lines) {
                if (s.indexOf("SSCN") > -1) {
                    this.setSscnSupport(true);
                    this.setSecureFXPType("SSCN");
                    continue;
                }
                if (s.indexOf("PRET") > -1) {
                    this.setPretSupport(true);
                    continue;
                }
                if (s.indexOf("CPSV") <= -1) continue;
                this.setCpsvSupport(true);
                this.setSecureFXPType("CPSV");
            }
        }
    }

    public boolean isCpsvSupport() {
        return this.cpsvSupport;
    }

    public void setCpsvSupport(boolean cpsvSupport) {
        this.cpsvSupport = cpsvSupport;
    }

    public boolean isSscnSupport() {
        return this.sscnSupport;
    }

    public void setSscnSupport(boolean sscnSupport) {
        this.sscnSupport = sscnSupport;
    }

    public void moveFile(FTPFile fromFile, FTPFile toFile) throws FtpWorkflowException, FtpIOException, IOException {
        this.renameFile(fromFile, toFile);
    }
}

