/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.automodel;

import java.util.ArrayList;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.DatabaseMetaInformation;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.pms.automodel.AutoModeler;
import org.pentaho.pms.automodel.SchemaTable;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.RelationshipMeta;
import org.pentaho.pms.schema.SchemaMeta;

public class AutoModelerScenario {
    public AutoModelerScenario() throws KettleDatabaseException, PentahoMetadataException {
        String databaseType = "MySQL";
        String hostname = "localhost";
        String port = "3306";
        String databaseName = "test";
        String username = "matt";
        String password = "abcd";
        DatabaseMeta databaseMeta = new DatabaseMeta(databaseName, databaseType, "JDBC", hostname, databaseName, port, username, password);
        DatabaseMetaInformation dmi = new DatabaseMetaInformation(databaseMeta);
        dmi.getData((LoggingObjectInterface)new LoggingObject((Object)"Auto Modeler"), null);
        String schemaName = dmi.getSchemas()[0].getSchemaName();
        String[] tableNames = dmi.getSchemas()[0].getItems();
        SchemaTable[] schemaTables = new SchemaTable[]{new SchemaTable("dwh", "d_customer"), new SchemaTable("dwh", "d_product"), new SchemaTable("dwh", "d_date"), new SchemaTable("dwh", "f_orderlines")};
        AutoModeler modeler = new AutoModeler("en_US", "Orders", databaseMeta, schemaTables);
        SchemaMeta schemaMeta = modeler.generateSchemaMeta();
        BusinessModel model = schemaMeta.getActiveModel();
        for (int i = 0; i < model.nrBusinessTables(); ++i) {
            BusinessTable leftTable = model.getBusinessTable(i);
            ArrayList<BusinessTable> tables = new ArrayList<BusinessTable>();
            for (int t = 0; t < model.nrBusinessTables(); ++t) {
                BusinessTable table = model.getBusinessTable(t);
                if (leftTable == table) continue;
                tables.add(table);
            }
            BusinessTable rightTable = (BusinessTable)tables.get(0);
            BusinessColumn leftColumn = leftTable.getBusinessColumn(0);
            BusinessColumn rightColumn = rightTable.getBusinessColumn(0);
            model.addRelationship(new RelationshipMeta(leftTable, rightTable, leftColumn, rightColumn));
        }
    }
}

