/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.Iterator;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.repository.IMetadataDomainRepository;

public class SecurityHelper {
    public Domain createSecureDomain(IMetadataDomainRepository repo, Domain domain) {
        Domain clone = (Domain)domain.clone();
        Iterator<LogicalModel> iter = clone.getLogicalModels().iterator();
        while (iter.hasNext()) {
            LogicalModel model = iter.next();
            if (!repo.hasAccess(0, model)) {
                iter.remove();
                continue;
            }
            Iterator<LogicalTable> tbliter = model.getLogicalTables().iterator();
            while (tbliter.hasNext()) {
                LogicalTable table = tbliter.next();
                if (!repo.hasAccess(0, table)) {
                    tbliter.remove();
                    continue;
                }
                Iterator<LogicalColumn> coliter = table.getLogicalColumns().iterator();
                while (coliter.hasNext()) {
                    LogicalColumn col = coliter.next();
                    if (repo.hasAccess(0, col)) continue;
                    coliter.remove();
                }
            }
            Iterator<Category> catiter = model.getCategories().iterator();
            while (catiter.hasNext()) {
                Category category = catiter.next();
                if (!repo.hasAccess(0, category)) {
                    catiter.remove();
                    continue;
                }
                Iterator<LogicalColumn> coliter = category.getLogicalColumns().iterator();
                while (coliter.hasNext()) {
                    LogicalColumn col = coliter.next();
                    if (repo.hasAccess(0, col)) continue;
                    coliter.remove();
                }
            }
        }
        return clone;
    }
}

