/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.thin;

import org.apache.commons.lang.StringUtils;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.thin.Operator;
import org.pentaho.metadata.query.model.CombinationType;

public class Condition {
    private static final long serialVersionUID = 6382700024558898605L;
    private String elementId;
    private String parentId;
    private String operator = Operator.EQUAL.name();
    private String[] value;
    private String comboType = CombinationType.AND.name();
    private boolean parameterized;
    private String selectedAggregation;

    public String getElementId() {
        return this.elementId;
    }

    public String getCombinationType() {
        return this.comboType;
    }

    public String getOperator() {
        return this.operator;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public void setCombinationType(String combinationType) {
        this.comboType = combinationType;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public boolean validate() {
        return true;
    }

    public String getCondition(String type) {
        return this.getCondition(type, this.isParameterized() ? this.value[0] : null);
    }

    public String getCondition(String type, String paramName) {
        boolean enforceParameters;
        String[] val = this.value;
        Operator theOperator = Operator.parse(this.operator);
        if (type.equalsIgnoreCase(DataType.STRING.getName()) && theOperator == Operator.EQUAL) {
            theOperator = Operator.EXACTLY_MATCHES;
        }
        boolean bl = enforceParameters = this.isParameterized() && paramName != null;
        if (!enforceParameters && type.equalsIgnoreCase(DataType.STRING.getName())) {
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "\"" + val[idx] + "\"";
            }
        }
        String columnName = "[" + this.parentId + "." + this.elementId + (StringUtils.isEmpty((String)this.selectedAggregation) ? "" : "." + this.selectedAggregation) + "]";
        if (type.equals(DataType.DATE.getName())) {
            if (enforceParameters) {
                for (int idx = 0; idx < val.length; ++idx) {
                    val[idx] = "DATEVALUE([param:" + this.value[idx].replaceAll("[\\{\\}]", "") + "])";
                }
                return theOperator.formatCondition(columnName, paramName, val, false);
            }
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "DATEVALUE(\"" + val[idx] + "\")";
            }
        }
        return theOperator.formatCondition(columnName, paramName, val, enforceParameters);
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    public void setParameterized(boolean parameterized) {
        this.parameterized = parameterized;
    }

    public void setSelectedAggregation(String aggType) {
        this.selectedAggregation = aggType;
    }

    public String getSelectedAggregation() {
        return this.selectedAggregation;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

