/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper;

import com.mongodb.DBCollection;
import com.mongodb.MongoClient;
import javax.security.auth.login.LoginContext;
import org.pentaho.mongo.AuthContext;
import org.pentaho.mongo.KerberosHelper;
import org.pentaho.mongo.MongoDbException;
import org.pentaho.mongo.MongoProp;
import org.pentaho.mongo.MongoProperties;
import org.pentaho.mongo.MongoUtilLogger;
import org.pentaho.mongo.wrapper.ConnectionStringMongoClientWrapper;
import org.pentaho.mongo.wrapper.DefaultMongoClientFactory;
import org.pentaho.mongo.wrapper.KerberosInvocationHandler;
import org.pentaho.mongo.wrapper.MongoClientFactory;
import org.pentaho.mongo.wrapper.collection.KerberosMongoCollectionWrapper;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;

public class KerberosConnectionStringMongoClientWrapper
extends ConnectionStringMongoClientWrapper {
    private final AuthContext authContext;
    MongoProperties props;

    KerberosConnectionStringMongoClientWrapper(String connectionString, MongoUtilLogger log) throws MongoDbException {
        super(connectionString, log);
        this.authContext = this.getAuthContext(this.props);
    }

    private MongoProperties getMongoProperties(String connectionString) {
        String principal = connectionString.substring(connectionString.indexOf("://") + 3, connectionString.indexOf(64));
        return new MongoProperties.Builder().set(MongoProp.USERNAME, principal).set(MongoProp.PENTAHO_JAAS_AUTH_MODE, "KERBEROS_USER").build();
    }

    private AuthContext getAuthContext(MongoProperties props) throws MongoDbException {
        if (this.authContext == null) {
            return new AuthContext(this.initLoginContext(props));
        }
        return this.authContext;
    }

    public AuthContext getAuthContext() {
        return this.authContext;
    }

    private LoginContext initLoginContext(MongoProperties props) throws MongoDbException {
        return KerberosHelper.login(props.get(MongoProp.USERNAME), props);
    }

    @Override
    public MongoClientFactory getClientFactory(String connectionString) {
        try {
            this.props = this.getMongoProperties(connectionString);
            return KerberosInvocationHandler.wrap(MongoClientFactory.class, this.getAuthContext(this.props), new DefaultMongoClientFactory());
        }
        catch (MongoDbException e) {
            return super.getClientFactory(connectionString);
        }
    }

    @Override
    public MongoClient getMongo() {
        return super.getMongo();
    }

    @Override
    protected MongoCollectionWrapper wrap(DBCollection collection) {
        return KerberosInvocationHandler.wrap(MongoCollectionWrapper.class, this.authContext, new KerberosMongoCollectionWrapper(collection, this.authContext));
    }
}

