/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.ui.RunConfigurationDelegate;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.SelectionTreeExtension;

@ExtensionPoint(id="RunConfigurationViewTreeExtension", description="Refreshes execution environment subtree", extensionPointId="SpoonViewTreeExtension")
public class RunConfigurationViewTreeExtension
implements ExtensionPointInterface {
    private static final Class<?> PKG = RunConfigurationViewTreeExtension.class;
    public static String TREE_LABEL = BaseMessages.getString(PKG, (String)"RunConfigurationTree.Title", (String[])new String[0]);
    private RunConfigurationDelegate runConfigurationDelegate = RunConfigurationDelegate.getInstance();

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        SelectionTreeExtension selectionTreeExtension = (SelectionTreeExtension)object;
        if (selectionTreeExtension.getAction().equals("REFRESH_SELECTION_EXTENSION")) {
            this.refreshTree(selectionTreeExtension);
        }
        if (selectionTreeExtension.getAction().equals("EDIT_SELECTION_EXTENSION")) {
            if (selectionTreeExtension.getSelection() instanceof RunConfiguration) {
                RunConfiguration runConfiguration = (RunConfiguration)selectionTreeExtension.getSelection();
                this.runConfigurationDelegate.edit(runConfiguration);
            }
            if (selectionTreeExtension.getSelection() instanceof String) {
                this.runConfigurationDelegate.edit(this.runConfigurationDelegate.load((String)selectionTreeExtension.getSelection()));
            }
        }
    }

    private void refreshTree(SelectionTreeExtension selectionTreeExtension) {
        TreeItem tiRootName = selectionTreeExtension.getTiRootName();
        GUIResource guiResource = selectionTreeExtension.getGuiResource();
        TreeItem tiEETitle = this.createTreeItem(tiRootName, TREE_LABEL, guiResource.getImageFolder(), 0);
        for (RunConfiguration runConfiguration : this.runConfigurationDelegate.load()) {
            String imageFile = runConfiguration.isReadOnly() ? "images/run_tree_disabled.svg" : "images/run_tree.svg";
            this.createTreeItem(tiEETitle, runConfiguration.getName(), this.getRunConfigurationImage(guiResource, imageFile), -1, runConfiguration.isReadOnly());
        }
    }

    private Image getRunConfigurationImage(GUIResource guiResource, String file) {
        return guiResource.getImage(file, this.getClass().getClassLoader(), 24, 24);
    }

    private TreeItem createTreeItem(TreeItem parent, String text, Image image, int index) {
        return this.createTreeItem(parent, text, image, index, false);
    }

    private TreeItem createTreeItem(TreeItem parent, String text, Image image, int index, boolean disabled) {
        TreeItem item;
        TreeItem treeItem = item = index == -1 ? new TreeItem(parent, 0) : new TreeItem(parent, 0, index);
        if (disabled) {
            item.setForeground(this.getDisabledColor());
        }
        item.setText(text);
        item.setImage(image);
        return item;
    }

    private Color getDisabledColor() {
        Display device = Display.getCurrent();
        return new Color((Device)device, 188, 188, 188);
    }
}

