/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import java.util.function.Supplier;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.engine.ui.RunConfigurationDelegate;
import org.pentaho.di.engine.ui.RunConfigurationFolderProvider;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.tree.TreeFolderProvider;

@LifecyclePlugin(id="RunConfigurationLifecycleListener")
public class RunConfigurationLifecycleListener
implements LifecycleListener {
    private RunConfigurationDelegate runConfigurationDelegate;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;

    public RunConfigurationLifecycleListener() {
        this.runConfigurationDelegate = RunConfigurationDelegate.getInstance();
    }

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        Spoon spoon = this.spoonSupplier.get();
        if (spoon != null) {
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_TRANSFORMATIONS, (TreeFolderProvider)new RunConfigurationFolderProvider(this.runConfigurationDelegate));
            spoon.getTreeManager().addTreeProvider(Spoon.STRING_JOBS, (TreeFolderProvider)new RunConfigurationFolderProvider(this.runConfigurationDelegate));
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
    }
}

