/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.extension;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.attributes.metastore.EmbeddedMetaStore;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.impl.EmbeddedRunConfigurationManager;
import org.pentaho.di.engine.configuration.impl.RunConfigurationManager;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryRunConfigurableInterface;

@ExtensionPoint(id="RunConfigurationSaveExtensionPoint", extensionPointId="JobEntryTransSave", description="")
public class RunConfigurationSaveExtensionPoint
implements ExtensionPointInterface {
    private RunConfigurationManager runConfigurationManager = RunConfigurationManager.getInstance();

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        JobMeta jobMeta = (JobMeta)((Object[])o)[0];
        EmbeddedMetaStore embeddedMetaStore = jobMeta.getEmbeddedMetaStore();
        RunConfigurationManager embeddedRunConfigurationManager = EmbeddedRunConfigurationManager.build(embeddedMetaStore);
        embeddedRunConfigurationManager.deleteAll();
        ArrayList<String> runConfigurationNames = new ArrayList<String>();
        boolean embedAll = false;
        for (JobEntryCopy jobEntryCopy : jobMeta.getJobCopies()) {
            if (!(jobEntryCopy.getEntry() instanceof JobEntryRunConfigurableInterface)) continue;
            String usedConfiguration = ((JobEntryRunConfigurableInterface)jobEntryCopy.getEntry()).getRunConfiguration();
            boolean bl = embedAll = embedAll || StringUtil.isVariable((String)usedConfiguration);
            if (Utils.isEmpty((CharSequence)usedConfiguration) || runConfigurationNames.contains(usedConfiguration)) continue;
            runConfigurationNames.add(usedConfiguration);
        }
        if (embedAll) {
            this.embedAllRunConfigurations(embeddedRunConfigurationManager);
        } else {
            this.embedRunConfigurations(embeddedRunConfigurationManager, runConfigurationNames);
        }
    }

    private void embedAllRunConfigurations(RunConfigurationManager embeddedRunConfigurationManager) {
        List<RunConfiguration> runConfigurations = this.runConfigurationManager.load();
        for (RunConfiguration loadedRunConfiguration : runConfigurations) {
            if (loadedRunConfiguration.isReadOnly()) continue;
            embeddedRunConfigurationManager.save(loadedRunConfiguration);
        }
    }

    private void embedRunConfigurations(RunConfigurationManager embeddedRunConfigurationManager, List<String> runConfigurationNames) {
        for (String runConfigurationName : runConfigurationNames) {
            if (runConfigurationName.equals("Pentaho local")) continue;
            RunConfiguration loadedRunConfiguration = this.runConfigurationManager.load(runConfigurationName);
            embeddedRunConfigurationManager.save(loadedRunConfiguration);
        }
    }

    @VisibleForTesting
    void setRunConfigurationManager(RunConfigurationManager runConfigurationManager) {
        this.runConfigurationManager = runConfigurationManager;
    }
}

