/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.extension;

import com.google.common.annotations.VisibleForTesting;
import org.pentaho.di.ExecutionConfiguration;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.attributes.metastore.EmbeddedMetaStore;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationExecutor;
import org.pentaho.di.engine.configuration.impl.EmbeddedRunConfigurationManager;
import org.pentaho.di.engine.configuration.impl.RunConfigurationManager;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;

@ExtensionPoint(id="RunConfigurationRunExtensionPoint", extensionPointId="SpoonTransBeforeStart", description="")
public class RunConfigurationRunExtensionPoint
implements ExtensionPointInterface {
    private static Class<?> PKG = RunConfigurationRunExtensionPoint.class;
    private RunConfigurationManager runConfigurationManager = RunConfigurationManager.getInstance();

    public void callExtensionPoint(LogChannelInterface logChannelInterface, Object o) throws KettleException {
        ExecutionConfiguration executionConfiguration = (ExecutionConfiguration)((Object[])o)[0];
        AbstractMeta meta = (AbstractMeta)((Object[])o)[1];
        VariableSpace variableSpace = (VariableSpace)((Object[])o)[2];
        Repository repository = (Repository)((Object[])o)[3];
        EmbeddedMetaStore embeddedMetaStore = meta.getEmbeddedMetaStore();
        RunConfiguration runConfiguration = this.runConfigurationManager.load(executionConfiguration.getRunConfiguration());
        if (runConfiguration == null) {
            RunConfigurationManager embeddedRunConfigurationManager = EmbeddedRunConfigurationManager.build(embeddedMetaStore);
            runConfiguration = embeddedRunConfigurationManager.load(executionConfiguration.getRunConfiguration());
        }
        if (runConfiguration != null) {
            RunConfigurationExecutor runConfigurationExecutor = this.runConfigurationManager.getExecutor(runConfiguration.getType());
            if (runConfigurationExecutor != null) {
                runConfigurationExecutor.execute(runConfiguration, executionConfiguration, meta, variableSpace, repository);
            }
        } else {
            String name = "";
            if (variableSpace instanceof TransMeta) {
                name = ((TransMeta)variableSpace).getFilename();
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"RunConfigurationRunExtensionPoint.ConfigNotFound.Error", (String[])new String[]{name, executionConfiguration.getRunConfiguration(), "{0}"}));
        }
    }

    @VisibleForTesting
    void setRunConfigurationManager(RunConfigurationManager runConfigurationManager) {
        this.runConfigurationManager = runConfigurationManager;
    }
}

