/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class UnsupportedProtocolVersionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;
    private final ProtocolVersion unsupportedVersion;
    private final ProtocolVersion serverVersion;

    public UnsupportedProtocolVersionException(InetSocketAddress address, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion) {
        super(UnsupportedProtocolVersionException.makeErrorMessage(address, unsupportedVersion, serverVersion));
        this.address = address;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    public UnsupportedProtocolVersionException(InetSocketAddress address, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion, Throwable cause) {
        super(UnsupportedProtocolVersionException.makeErrorMessage(address, unsupportedVersion, serverVersion), cause);
        this.address = address;
        this.unsupportedVersion = unsupportedVersion;
        this.serverVersion = serverVersion;
    }

    private static String makeErrorMessage(InetSocketAddress address, ProtocolVersion unsupportedVersion, ProtocolVersion serverVersion) {
        return unsupportedVersion == serverVersion ? String.format("[%s] Host does not support protocol version %s", new Object[]{address, unsupportedVersion}) : String.format("[%s] Host does not support protocol version %s but %s", new Object[]{address, unsupportedVersion, serverVersion});
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public ProtocolVersion getUnsupportedVersion() {
        return this.unsupportedVersion;
    }

    @Override
    public UnsupportedProtocolVersionException copy() {
        return new UnsupportedProtocolVersionException(this.address, this.unsupportedVersion, this.serverVersion, this);
    }
}

