/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;

public class SwingMenuitem
extends SwingElement
implements XulMenuitem {
    private static final Log logger = LogFactory.getLog(SwingMenuitem.class);
    private JMenuItem menuitem = new JMenuItem();
    private String image;
    private String onCommand;

    public SwingMenuitem(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menuitem");
        this.setManagedObject(this.menuitem);
    }

    public String getAcceltext() {
        return String.valueOf(this.menuitem.getAccelerator().getKeyChar());
    }

    public String getAccesskey() {
        return String.valueOf(this.menuitem.getText().charAt(this.menuitem.getDisplayedMnemonicIndex()));
    }

    @Override
    public boolean isDisabled() {
        return !this.menuitem.isEnabled();
    }

    public String getLabel() {
        return this.menuitem.getText();
    }

    public void setAcceltext(String accel) {
        this.menuitem.setAccelerator(KeyStroke.getKeyStroke(accel));
    }

    public void setAccesskey(String accessKey) {
        if (accessKey == null || accessKey.length() == 0) {
            this.menuitem.setMnemonic(0);
        } else {
            this.menuitem.setMnemonic(accessKey.charAt(0));
        }
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.menuitem.setEnabled(!disabled);
    }

    public void setDisabled(String disabled) {
        this.menuitem.setEnabled(!Boolean.parseBoolean(disabled));
    }

    public void setLabel(String label) {
        this.menuitem.setText(label);
    }

    public String getImage() {
        return this.image;
    }

    public boolean isSelected() {
        return this.menuitem.isSelected();
    }

    public void setSelected(boolean selected) {
        this.menuitem.setSelected(selected);
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getCommand() {
        return this.onCommand;
    }

    public void setCommand(final String command) {
        this.onCommand = command;
        this.menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingMenuitem.this.invoke(command);
            }
        });
    }

    public String toString() {
        return this.getLabel();
    }
}

