/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.FilterSpans;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

public class SpanPayloadCheckQuery
extends SpanQuery {
    protected final List<BytesRef> payloadToMatch;
    protected final SpanQuery match;

    public SpanPayloadCheckQuery(SpanQuery match, List<BytesRef> payloadToMatch) {
        this.match = match;
        this.payloadToMatch = payloadToMatch;
    }

    public String getField() {
        return this.match.getField();
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        SpanWeight matchWeight = this.match.createWeight(searcher, false, boost);
        return new SpanPayloadCheckWeight(searcher, needsScores ? SpanPayloadCheckQuery.getTermContexts((SpanWeight[])new SpanWeight[]{matchWeight}) : null, matchWeight, boost);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query matchRewritten = this.match.rewrite(reader);
        if (this.match != matchRewritten && matchRewritten instanceof SpanQuery) {
            return new SpanPayloadCheckQuery((SpanQuery)matchRewritten, this.payloadToMatch);
        }
        return super.rewrite(reader);
    }

    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SpanPayloadCheckQuery(");
        buffer.append(this.match.toString(field));
        buffer.append(", payloadRef: ");
        for (BytesRef bytes : this.payloadToMatch) {
            buffer.append(Term.toString((BytesRef)bytes));
            buffer.append(';');
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.payloadToMatch.equals(((SpanPayloadCheckQuery)((Object)other)).payloadToMatch) && this.match.equals((Object)((SpanPayloadCheckQuery)((Object)other)).match);
    }

    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + Objects.hashCode(this.match);
        result = 31 * result + Objects.hashCode(this.payloadToMatch);
        return result;
    }

    private class PayloadChecker
    implements SpanCollector {
        int upto = 0;
        boolean matches = true;

        private PayloadChecker() {
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            if (!this.matches) {
                return;
            }
            if (this.upto >= SpanPayloadCheckQuery.this.payloadToMatch.size()) {
                this.matches = false;
                return;
            }
            BytesRef payload = postings.getPayload();
            if (SpanPayloadCheckQuery.this.payloadToMatch.get(this.upto) == null) {
                this.matches = payload == null;
                ++this.upto;
                return;
            }
            if (payload == null) {
                this.matches = false;
                ++this.upto;
                return;
            }
            this.matches = SpanPayloadCheckQuery.this.payloadToMatch.get(this.upto).bytesEquals(payload);
            ++this.upto;
        }

        FilterSpans.AcceptStatus match() {
            return this.matches && this.upto == SpanPayloadCheckQuery.this.payloadToMatch.size() ? FilterSpans.AcceptStatus.YES : FilterSpans.AcceptStatus.NO;
        }

        public void reset() {
            this.upto = 0;
            this.matches = true;
        }
    }

    public class SpanPayloadCheckWeight
    extends SpanWeight {
        final SpanWeight matchWeight;

        public SpanPayloadCheckWeight(IndexSearcher searcher, Map<Term, TermContext> termContexts, SpanWeight matchWeight, float boost) throws IOException {
            super((SpanQuery)SpanPayloadCheckQuery.this, searcher, termContexts, boost);
            this.matchWeight = matchWeight;
        }

        public void extractTerms(Set<Term> terms) {
            this.matchWeight.extractTerms(terms);
        }

        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.matchWeight.extractTermContexts(contexts);
        }

        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            final PayloadChecker collector = new PayloadChecker();
            Spans matchSpans = this.matchWeight.getSpans(context, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
            return matchSpans == null ? null : new FilterSpans(matchSpans){

                protected FilterSpans.AcceptStatus accept(Spans candidate) throws IOException {
                    collector.reset();
                    candidate.collect((SpanCollector)collector);
                    return collector.match();
                }
            };
        }

        public SpanScorer scorer(LeafReaderContext context) throws IOException {
            if (this.field == null) {
                return null;
            }
            Terms terms = context.reader().terms(this.field);
            if (terms != null && !terms.hasPositions()) {
                throw new IllegalStateException("field \"" + this.field + "\" was indexed without position data; cannot run SpanQuery (query=" + this.parentQuery + ")");
            }
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            Similarity.SimScorer docScorer = this.getSimScorer(context);
            return new SpanScorer((SpanWeight)this, spans, docScorer);
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.matchWeight.isCacheable(ctx);
        }
    }
}

