/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.edi2xml;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.edi2xml.Edi2XmlData;
import org.pentaho.di.trans.steps.edi2xml.Edi2XmlMeta;
import org.pentaho.di.trans.steps.edi2xml.grammar.FastSimpleGenericEdifactDirectXMLLexer;
import org.pentaho.di.trans.steps.edi2xml.grammar.FastSimpleGenericEdifactDirectXMLParser;

public class Edi2Xml
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = Edi2XmlMeta.class;
    private Edi2XmlData data;
    private Edi2XmlMeta meta;
    private FastSimpleGenericEdifactDirectXMLLexer lexer;
    private CommonTokenStream tokens;
    private FastSimpleGenericEdifactDirectXMLParser parser;

    public Edi2Xml(StepMeta s, StepDataInterface stepDataInterface, int c, TransMeta t, Trans dis) {
        super(s, stepDataInterface, c, t, dis);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        StringBuilder errorMessage;
        this.meta = (Edi2XmlMeta)smi;
        this.data = (Edi2XmlData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        String inputValue = "";
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
            String realInputField = this.environmentSubstitute(this.meta.getInputField());
            String realOutputField = this.environmentSubstitute(this.meta.getOutputField());
            this.data.inputFieldIndex = this.getInputRowMeta().indexOfValue(realInputField);
            int numErrors = 0;
            if (this.data.inputFieldIndex < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Edi2Xml.Log.CouldNotFindInputField", (String[])new String[]{realInputField}));
                ++numErrors;
            }
            if (!this.data.inputRowMeta.getValueMeta(this.data.inputFieldIndex).isString()) {
                this.logError(BaseMessages.getString(PKG, (String)"Edi2Xml.Log.InputFieldIsNotAString", (String[])new String[]{realInputField}));
                ++numErrors;
            }
            if (numErrors > 0) {
                this.setErrors(numErrors);
                this.stopAll();
                return false;
            }
            this.data.inputMeta = this.data.inputRowMeta.getValueMeta(this.data.inputFieldIndex);
            if (Utils.isEmpty((CharSequence)this.meta.getOutputField())) {
                this.data.outputMeta = this.data.outputRowMeta.getValueMeta(this.data.inputFieldIndex);
                this.data.outputFieldIndex = this.data.inputFieldIndex;
            } else {
                this.data.outputMeta = this.data.outputRowMeta.searchValueMeta(realOutputField);
                this.data.outputFieldIndex = this.data.outputRowMeta.size() - 1;
            }
            inputValue = Const.NVL((String)this.data.inputMeta.getString(r[this.data.inputFieldIndex]), (String)"");
            this.lexer = new FastSimpleGenericEdifactDirectXMLLexer((CharStream)new ANTLRStringStream(inputValue));
            this.tokens = new CommonTokenStream((TokenSource)this.lexer);
            this.parser = new FastSimpleGenericEdifactDirectXMLParser((TokenStream)this.tokens);
        } else {
            inputValue = Const.NVL((String)this.data.inputMeta.getString(r[this.data.inputFieldIndex]), (String)"");
            this.lexer.setCharStream((CharStream)new ANTLRStringStream(inputValue));
            this.tokens.setTokenSource((TokenSource)this.lexer);
            this.parser.setTokenStream((TokenStream)this.tokens);
        }
        try {
            this.parser.edifact();
            r = RowDataUtil.resizeArray((Object[])r, (int)this.data.outputRowMeta.size());
            r[this.data.outputFieldIndex] = this.parser.buf.toString();
            this.putRow(this.data.outputRowMeta, r);
        }
        catch (MismatchedTokenException e) {
            errorMessage = new StringBuilder(180);
            errorMessage.append("error parsing edi on line " + e.line + " position " + e.charPositionInLine);
            errorMessage.append(": expecting " + (e.expecting > -1 ? this.parser.getTokenNames()[e.expecting] : "<UNKNOWN>") + " but found ");
            errorMessage.append(e.token.getType() >= 0 ? this.parser.getTokenNames()[e.token.getType()] : "<EOF>");
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage.toString(), this.environmentSubstitute(this.meta.getInputField()), "MALFORMED_EDI");
            }
            this.logError(errorMessage.toString());
            String errorline = "<UNKNOWN>";
            try {
                errorline = inputValue.split("\\r?\\n")[e.line - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError("Problem line: " + errorline);
            this.logError(StringUtils.leftPad((String)"^", (int)(e.charPositionInLine + "Problem line: ".length() + 1)));
            throw new KettleException((Throwable)e);
        }
        catch (RecognitionException e) {
            errorMessage = new StringBuilder(180);
            errorMessage.append("error parsing edi on line ").append(e.line).append(" position ").append(e.charPositionInLine).append(". ").append(e.toString());
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage.toString(), this.environmentSubstitute(this.meta.getInputField()), "MALFORMED_EDI");
            }
            this.logError(errorMessage.toString());
            String errorline = "<UNKNOWN>";
            try {
                errorline = inputValue.split("\\r?\\n")[e.line - 1];
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logError("Problem line: " + errorline);
            this.logError(StringUtils.leftPad((String)"^", (int)(e.charPositionInLine + "Problem line: ".length() + 1)));
            throw new KettleException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (Edi2XmlMeta)smi;
        this.data = (Edi2XmlData)sdi;
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (Edi2XmlMeta)smi;
        this.data = (Edi2XmlData)sdi;
        this.data.inputMeta = null;
        this.data.inputRowMeta = null;
        this.data.outputMeta = null;
        this.data.outputRowMeta = null;
        super.dispose(smi, sdi);
    }
}

