/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.locator;

import java.util.List;
import org.pentaho.metaverse.locator.LocatorRunner;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryLocatorRunner
extends LocatorRunner<List<RepositoryFileTree>> {
    private static final Logger LOG = LoggerFactory.getLogger(LocatorRunner.class);

    @Override
    public void locate(List<RepositoryFileTree> fileTrees) {
        for (RepositoryFileTree fileTree : fileTrees) {
            if (this.stopping) {
                return;
            }
            if (fileTree.getFile() == null) continue;
            RepositoryFile file = fileTree.getFile();
            if (!file.isFolder()) {
                if (file.isHidden().booleanValue()) continue;
                try {
                    this.processFile(this.locator.getNamespace(), file.getName(), file.getPath(), file);
                }
                catch (Exception e) {
                    LOG.error(Messages.getString("ERROR.ProcessFileFailed", file.getName()), (Throwable)e);
                }
                continue;
            }
            List kids = fileTree.getChildren();
            if (kids == null || kids.size() <= 0) continue;
            this.locate(kids);
        }
    }
}

